package com.xforceplus.jctke.controller;


/**
 * 收货单原始数据feign客户端
 *
 * @author ultraman
 * @date 2022-07-02
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.GoodsReceiptInit;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface GoodsReceiptInitFeignApi {

  /**
   * 通过id查询收货单原始数据
   * @param  id
   * @return R
   */
  @GetMapping("/goodsReceiptInit/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增收货单原始数据
   * @param goodsReceiptInit 收货单原始数据
   * @return R
   */
  @PostMapping("/goodsReceiptInit/add")
  public R save(@RequestBody GoodsReceiptInit goodsReceiptInit);

  /**
   * 修改收货单原始数据
   * @param goodsReceiptInit 收货单原始数据
   * @return R
   */
  @PostMapping("/goodsReceiptInit/update")
  public R updateById(@RequestBody GoodsReceiptInit goodsReceiptInit);

  /**
   * 通过id删除收货单原始数据
   * @param  id
   * @return R
   */
  @DeleteMapping("/goodsReceiptInit/del/{id}" )
  public R removeById(@PathVariable Long id);

}