package com.xforceplus.jctke.controller;


/**
 * feign客户端
 *
 * @author ultraman
 * @date 2022-10-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.InvoiceNoticeBillItem;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface InvoiceNoticeBillItemFeignApi {

  /**
   * 通过id查询
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceNoticeBillItem/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增
   * @param invoiceNoticeBillItem 
   * @return R
   */
  @PostMapping("/invoiceNoticeBillItem/add")
  public R save(@RequestBody InvoiceNoticeBillItem invoiceNoticeBillItem);

  /**
   * 修改
   * @param invoiceNoticeBillItem 
   * @return R
   */
  @PostMapping("/invoiceNoticeBillItem/update")
  public R updateById(@RequestBody InvoiceNoticeBillItem invoiceNoticeBillItem);

  /**
   * 通过id删除
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceNoticeBillItem/del/{id}" )
  public R removeById(@PathVariable Long id);

}