package com.xforceplus.jctke.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2022-12-08
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jctke.entity.Wbs;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface WbsFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/wbs/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param wbs ${table.comment}
   * @return R
   */
  @PostMapping("/wbs/add")
  public R save(@RequestBody Wbs wbs);

  /**
   * 修改${table.comment}
   * @param wbs ${table.comment}
   * @return R
   */
  @PostMapping("/wbs/update")
  public R updateById(@RequestBody Wbs wbs);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/wbs/del/{id}" )
  public R removeById(@PathVariable Long id);

}