package com.xforceplus.jctke.controller;


/**
 * 自动收货记录feign客户端
 *
 * @author ultraman
 * @date 2023-04-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jctke.entity.AutoGoodsRecode;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface AutoGoodsRecodeFeignApi {

  /**
   * 通过id查询自动收货记录
   * @param  id
   * @return R
   */
  @GetMapping("/autoGoodsRecode/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增自动收货记录
   * @param autoGoodsRecode 自动收货记录
   * @return R
   */
  @PostMapping("/autoGoodsRecode/add")
  public R save(@RequestBody AutoGoodsRecode autoGoodsRecode);

  /**
   * 修改自动收货记录
   * @param autoGoodsRecode 自动收货记录
   * @return R
   */
  @PostMapping("/autoGoodsRecode/update")
  public R updateById(@RequestBody AutoGoodsRecode autoGoodsRecode);

  /**
   * 通过id删除自动收货记录
   * @param  id
   * @return R
   */
  @DeleteMapping("/autoGoodsRecode/del/{id}" )
  public R removeById(@PathVariable Long id);

}