package com.xforceplus.jctke.controller;


/**
 * 开票通知单主信息feign客户端
 *
 * @author ultraman
 * @date 2023-04-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jctke.entity.InvoiceNoticeBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface InvoiceNoticeBillFeignApi {

  /**
   * 通过id查询开票通知单主信息
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceNoticeBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增开票通知单主信息
   * @param invoiceNoticeBill 开票通知单主信息
   * @return R
   */
  @PostMapping("/invoiceNoticeBill/add")
  public R save(@RequestBody InvoiceNoticeBill invoiceNoticeBill);

  /**
   * 修改开票通知单主信息
   * @param invoiceNoticeBill 开票通知单主信息
   * @return R
   */
  @PostMapping("/invoiceNoticeBill/update")
  public R updateById(@RequestBody InvoiceNoticeBill invoiceNoticeBill);

  /**
   * 通过id删除开票通知单主信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceNoticeBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}