package com.xforceplus.jctke.controller;


/**
 * 原审批历史表feign客户端
 *
 * @author ultraman
 * @date 2024-01-25
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jctke.entity.ApprovalHistory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface ApprovalHistoryFeignApi {

  /**
   * 通过id查询原审批历史表
   * @param  id
   * @return R
   */
  @GetMapping("/approvalHistory/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增原审批历史表
   * @param approvalHistory 原审批历史表
   * @return R
   */
  @PostMapping("/approvalHistory/add")
  public R save(@RequestBody ApprovalHistory approvalHistory);

  /**
   * 修改原审批历史表
   * @param approvalHistory 原审批历史表
   * @return R
   */
  @PostMapping("/approvalHistory/update")
  public R updateById(@RequestBody ApprovalHistory approvalHistory);

  /**
   * 通过id删除原审批历史表
   * @param  id
   * @return R
   */
  @DeleteMapping("/approvalHistory/del/{id}" )
  public R removeById(@PathVariable Long id);

}