package com.xforceplus.jctke.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-01-25
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jctke.entity.ClosingDate;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface ClosingDateFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/closingDate/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param closingDate ${table.comment}
   * @return R
   */
  @PostMapping("/closingDate/add")
  public R save(@RequestBody ClosingDate closingDate);

  /**
   * 修改${table.comment}
   * @param closingDate ${table.comment}
   * @return R
   */
  @PostMapping("/closingDate/update")
  public R updateById(@RequestBody ClosingDate closingDate);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/closingDate/del/{id}" )
  public R removeById(@PathVariable Long id);

}