package com.xforceplus.jctke.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-01-29
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jctke.entity.DispatcherRuleConfig;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface DispatcherRuleConfigFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/dispatcherRuleConfig/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param dispatcherRuleConfig ${table.comment}
   * @return R
   */
  @PostMapping("/dispatcherRuleConfig/add")
  public R save(@RequestBody DispatcherRuleConfig dispatcherRuleConfig);

  /**
   * 修改${table.comment}
   * @param dispatcherRuleConfig ${table.comment}
   * @return R
   */
  @PostMapping("/dispatcherRuleConfig/update")
  public R updateById(@RequestBody DispatcherRuleConfig dispatcherRuleConfig);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/dispatcherRuleConfig/del/{id}" )
  public R removeById(@PathVariable Long id);

}