package com.xforceplus.jctke.controller;


/**
 * 付款数据补录履历feign客户端
 *
 * @author ultraman
 * @date 2024-06-24
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jctke.entity.DataMirgrationRecord;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface DataMirgrationRecordFeignApi {

  /**
   * 通过id查询付款数据补录履历
   * @param  id
   * @return R
   */
  @GetMapping("/dataMirgrationRecord/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增付款数据补录履历
   * @param dataMirgrationRecord 付款数据补录履历
   * @return R
   */
  @PostMapping("/dataMirgrationRecord/add")
  public R save(@RequestBody DataMirgrationRecord dataMirgrationRecord);

  /**
   * 修改付款数据补录履历
   * @param dataMirgrationRecord 付款数据补录履历
   * @return R
   */
  @PostMapping("/dataMirgrationRecord/update")
  public R updateById(@RequestBody DataMirgrationRecord dataMirgrationRecord);

  /**
   * 通过id删除付款数据补录履历
   * @param  id
   * @return R
   */
  @DeleteMapping("/dataMirgrationRecord/del/{id}" )
  public R removeById(@PathVariable Long id);

}