package com.xforceplus.jctke.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-03-17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AccountPayAble implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 申请ID
   */
  @TableField("applyId")
  private String applyId;

  /**
   * 付款单类型
   */
  @TableField("paymentType")
  private String paymentType;

  /**
   * 前置业务类型
   */
  @TableField("businessType")
  private String businessType;

  /**
   * 付款ID
   */
  @TableField("paymentId")
  private String paymentId;

  /**
   * 付款对象
   */
  @TableField("paymentName")
  private String paymentName;

  /**
   * 订单总金额
   */
  @TableField("totalAmount")
  private String totalAmount;

  /**
   * 历史已付金额
   */
  @TableField("hisPayAmount")
  private String hisPayAmount;

  /**
   * 发票总金额
   */
  @TableField("invoiceTotalAmount")
  private String invoiceTotalAmount;

  /**
   * 本次结算金额
   */
  @TableField("curSetmentAmount")
  private String curSetmentAmount;

  /**
   * 预付款凭证号
   */
  @TableField("advPayVoucherNo")
  private String advPayVoucherNo;

  /**
   * 预付款金额
   */
  @TableField("advPayAmount")
  private String advPayAmount;

  /**
   * 本次实付金额
   */
  @TableField("curPayAmount")
  private String curPayAmount;

  /**
   * 附件
   */
  @TableField("appendDix")
  private String appendDix;

  /**
   * 状态
   */
  private String status;

  /**
   * 应付款凭证号
   */
  @TableField("payVoucherNo")
  private String payVoucherNo;

  /**
   * 下载者
   */
  @TableField("downName")
  private String downName;

  /**
   * 下载状态
   */
  @TableField("downStatus")
  private String downStatus;

  /**
   * 付款到期日
   */
  @TableField("endPayTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endPayTime;

  /**
   * 当前审批人
   */
  @TableField("curApprovalName")
  private String curApprovalName;

  /**
   * 审批历史
   */
  @TableField("hisApprovalMsg")
  private String hisApprovalMsg;

  /**
   * 文本
   */
  @TableField("textMsg")
  private String textMsg;

  /**
   * 业务单号
   */
  @TableField("businessNo")
  private String businessNo;

  /**
   * 异常信息
   */
  @TableField("exceptMsg")
  private String exceptMsg;

  /**
   * 扩展字段1
   */
  private String ext1;

  /**
   * 扩展字段2
   */
  private String ext2;

  /**
   * 扩展字段3
   */
  private String ext3;

  /**
   * 扩展字段4
   */
  private String ext4;

  /**
   * 扩展字段5
   */
  private String ext5;

  /**
   * 扩展字段6
   */
  private String ext6;

  /**
   * 扩展字段7
   */
  private String ext7;

  /**
   * 扩展字段8
   */
  private String ext8;

  /**
   * 扩展字段9
   */
  private String ext9;

  /**
   * 扩展字段10
   */
  private String ext10;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("applyId", applyId);
      map.put("paymentType", paymentType);
      map.put("businessType", businessType);
      map.put("paymentId", paymentId);
      map.put("paymentName", paymentName);
      map.put("totalAmount", totalAmount);
      map.put("hisPayAmount", hisPayAmount);
      map.put("invoiceTotalAmount", invoiceTotalAmount);
      map.put("curSetmentAmount", curSetmentAmount);
      map.put("advPayVoucherNo", advPayVoucherNo);
      map.put("advPayAmount", advPayAmount);
      map.put("curPayAmount", curPayAmount);
      map.put("appendDix", appendDix);
      map.put("status", status);
      map.put("payVoucherNo", payVoucherNo);
      map.put("downName", downName);
      map.put("downStatus", downStatus);
      map.put("endPayTime", BocpGenUtils.toTimestamp(endPayTime));
      map.put("curApprovalName", curApprovalName);
      map.put("hisApprovalMsg", hisApprovalMsg);
      map.put("textMsg", textMsg);
      map.put("businessNo", businessNo);
      map.put("exceptMsg", exceptMsg);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static AccountPayAble fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    AccountPayAble entity = new AccountPayAble();
    if(map.containsKey("applyId")) {
      Object obj = map.get("applyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentId")) {
      Object obj = map.get("paymentId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentName")) {
      Object obj = map.get("paymentName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hisPayAmount")) {
      Object obj = map.get("hisPayAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHisPayAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceTotalAmount")) {
      Object obj = map.get("invoiceTotalAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceTotalAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("curSetmentAmount")) {
      Object obj = map.get("curSetmentAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurSetmentAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("advPayVoucherNo")) {
      Object obj = map.get("advPayVoucherNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAdvPayVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("advPayAmount")) {
      Object obj = map.get("advPayAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAdvPayAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("curPayAmount")) {
      Object obj = map.get("curPayAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurPayAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appendDix")) {
      Object obj = map.get("appendDix");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAppendDix((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payVoucherNo")) {
      Object obj = map.get("payVoucherNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("downName")) {
      Object obj = map.get("downName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("downStatus")) {
      Object obj = map.get("downStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("endPayTime")) {
      Object obj = map.get("endPayTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndPayTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndPayTime(null);
      }
    }
    if(map.containsKey("curApprovalName")) {
      Object obj = map.get("curApprovalName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurApprovalName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hisApprovalMsg")) {
      Object obj = map.get("hisApprovalMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHisApprovalMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("textMsg")) {
      Object obj = map.get("textMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTextMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessNo")) {
      Object obj = map.get("businessNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exceptMsg")) {
      Object obj = map.get("exceptMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
