package com.xforceplus.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 总账标识
 * </p>
 *
 * @author ultraman
 * @since 2022-04-14
 */
public enum LedgerType {

    D("D", "备用金"),
    B("B", "投标保证金"),
    A("A", "其它默认值");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    LedgerType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LedgerType fromCode(String code){
        switch(code) {
            case "D":
                return D;
            case "B":
                return B;
            case "A":
                return A;
            default:
                return null;
        }
    }
}
