package com.xforceplus.jctke.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * Rpa任务回执初始表
 * </p>
 *
 * @author ultraman
 * @since 2022-04-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class RpaResponse implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 任务号
   */
  @TableField("taskNo")
  private String taskNo;

  /**
   * 任务类型
   */
  @TableField("taskType")
  private String taskType;

  /**
   * 任务状态
   */
  private String status;

  /**
   * 预付款请求号
   */
  @TableField("prePaymentNo")
  private String prePaymentNo;

  /**
   * 预付款凭证号 
   */
  @TableField("prePaymentVoucherNo")
  private String prePaymentVoucherNo;

  /**
   * 预付款核销凭证
   */
  @TableField("prePayment")
  private String prePayment;

  /**
   * 应付款凭证
   */
  @TableField("paymentVoucherNo")
  private String paymentVoucherNo;

  /**
   * 应付款清账凭证
   */
  @TableField("settleAccountsVoucherNo")
  private String settleAccountsVoucherNo;

  /**
   * 应付款支付凭证
   */
  @TableField("paymentVoucherNoTwo")
  private String paymentVoucherNoTwo;

  /**
   * 异常信息
   */
  @TableField("errorInfo")
  private String errorInfo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("taskNo", taskNo);
      map.put("taskType", taskType);
      map.put("status", status);
      map.put("prePaymentNo", prePaymentNo);
      map.put("prePaymentVoucherNo", prePaymentVoucherNo);
      map.put("prePayment", prePayment);
      map.put("paymentVoucherNo", paymentVoucherNo);
      map.put("settleAccountsVoucherNo", settleAccountsVoucherNo);
      map.put("paymentVoucherNoTwo", paymentVoucherNoTwo);
      map.put("errorInfo", errorInfo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static RpaResponse fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    RpaResponse entity = new RpaResponse();
    if(map.containsKey("taskNo")) {
      Object obj = map.get("taskNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaskNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taskType")) {
      Object obj = map.get("taskType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaskType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prePaymentNo")) {
      Object obj = map.get("prePaymentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrePaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prePaymentVoucherNo")) {
      Object obj = map.get("prePaymentVoucherNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrePaymentVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prePayment")) {
      Object obj = map.get("prePayment");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrePayment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentVoucherNo")) {
      Object obj = map.get("paymentVoucherNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settleAccountsVoucherNo")) {
      Object obj = map.get("settleAccountsVoucherNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettleAccountsVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentVoucherNoTwo")) {
      Object obj = map.get("paymentVoucherNoTwo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentVoucherNoTwo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorInfo")) {
      Object obj = map.get("errorInfo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setErrorInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
