package com.xforceplus.jctke.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-04-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PaymentManage implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 申请ID
   */
  @TableField("applyId")
  private String applyId;

  /**
   * 申请人
   */
  @TableField("applyUserName")
  private String applyUserName;

  /**
   * 付款类型
   */
  @TableField("paymentType")
  private String paymentType;

  /**
   * 业务类型
   */
  @TableField("businessType")
  private String businessType;

  /**
   * 预付款类型
   */
  @TableField("prepaymentType")
  private String prepaymentType;

  /**
   * 代理费类型
   */
  @TableField("agencyFeeType")
  private String agencyFeeType;

  /**
   * 保证金类型
   */
  @TableField("bondType")
  private String bondType;

  /**
   * 换票类型
   */
  @TableField("changeTicketType")
  private String changeTicketType;

  /**
   * 采购组
   */
  @TableField("procurementGroup")
  private String procurementGroup;

  /**
   * 付款对象ID
   */
  @TableField("paymentObjectId")
  private String paymentObjectId;

  /**
   * 付款对象
   */
  @TableField("paymentObject")
  private String paymentObject;

  /**
   * 本次申请支付金额
   */
  @TableField("applyPaymentAmount")
  private String applyPaymentAmount;

  /**
   * 本次申请实付金额
   */
  @TableField("applyPaidAmount")
  private String applyPaidAmount;

  /**
   * 订单总金额
   */
  @TableField("orderAmount")
  private String orderAmount;

  /**
   * 发票总金额
   */
  @TableField("invoiceAmount")
  private String invoiceAmount;

  /**
   * 预付金额
   */
  @TableField("prepaymentAmount")
  private String prepaymentAmount;

  /**
   * 收款累计
   */
  @TableField("collectionAccumulation")
  private String collectionAccumulation;

  /**
   * 付款累计
   */
  @TableField("paymentAccumulation")
  private String paymentAccumulation;

  /**
   * 预付款请求号
   */
  @TableField("prepaymentRequestNo")
  private String prepaymentRequestNo;

  /**
   * 预付款支付凭证
   */
  @TableField("prepaymentPaymentVoucher")
  private String prepaymentPaymentVoucher;

  /**
   * 预付款核销凭证
   */
  @TableField("prepaymentWriteVoucher")
  private String prepaymentWriteVoucher;

  /**
   * 应付款凭证
   */
  @TableField("paymentVoucher")
  private String paymentVoucher;

  /**
   * 应付款支付凭证
   */
  @TableField("paymentPaymentVoucher")
  private String paymentPaymentVoucher;

  /**
   * 应付款清账凭证
   */
  @TableField("paymentClearingVoucher")
  private String paymentClearingVoucher;

  /**
   * 当前状态
   */
  @TableField("currentStatus")
  private String currentStatus;

  /**
   * 异常信息
   */
  @TableField("errorInfo")
  private String errorInfo;

  /**
   * 利润中心
   */
  @TableField("profitCenter")
  private String profitCenter;

  /**
   * 成本中心
   */
  @TableField("costCenter")
  private String costCenter;

  /**
   * 付款人类型
   */
  @TableField("paymentUserType")
  private String paymentUserType;

  /**
   * 付款到期日
   */
  @TableField("paymentDueDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentDueDate;

  /**
   * 付款银行类型
   */
  @TableField("paymentBankType")
  private String paymentBankType;

  /**
   * 收款银行
   */
  @TableField("collectionBank")
  private String collectionBank;

  /**
   * 收款账户
   */
  @TableField("collectionAccount")
  private String collectionAccount;

  /**
   * 收款户名
   */
  @TableField("collectionName")
  private String collectionName;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 合同名称
   */
  @TableField("contractName")
  private String contractName;

  /**
   * 合同金额
   */
  @TableField("contractAmount")
  private String contractAmount;

  /**
   * 合同类型
   */
  @TableField("contractType")
  private String contractType;

  /**
   * 起始日
   */
  @TableField("startDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startDate;

  /**
   * 截止日
   */
  @TableField("endDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endDate;

  /**
   * 附件
   */
  private String file;

  /**
   * 文本
   */
  private String text;

  /**
   * 付款备注
   */
  @TableField("paymentRemark")
  private String paymentRemark;

  /**
   * 审批历史
   */
  @TableField("approvalHistory")
  private String approvalHistory;

  /**
   * 下载者
   */
  @TableField("downloadUserName")
  private String downloadUserName;

  /**
   * 下载状态
   */
  @TableField("downloadStatus")
  private String downloadStatus;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 合同签订日
   */
  @TableField("contractSignDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime contractSignDate;

  /**
   * 附件地址
   */
  @TableField("fileUrl")
  private String fileUrl;

  /**
   * 附件名称
   */
  @TableField("fileName")
  private String fileName;

  /**
   * 开票通知单号
   */
  @TableField("invoiceNoticeNOs")
  private String invoiceNoticeNOs;

  /**
   * 当前审批角色
   */
  @TableField("approvalRole")
  private String approvalRole;

  /**
   * 采购订单号
   */
  @TableField("poNos")
  private String poNos;

  /**
   * 分公司id
   */
  @TableField("companyId")
  private String companyId;

  /**
   * 分公司名称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 分公司发票抬头id
   */
  @TableField("purchaserId")
  private String purchaserId;

  /**
   * 分公司发票抬头名称
   */
  @TableField("purchaserName")
  private String purchaserName;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("applyId", applyId);
      map.put("applyUserName", applyUserName);
      map.put("paymentType", paymentType);
      map.put("businessType", businessType);
      map.put("prepaymentType", prepaymentType);
      map.put("agencyFeeType", agencyFeeType);
      map.put("bondType", bondType);
      map.put("changeTicketType", changeTicketType);
      map.put("procurementGroup", procurementGroup);
      map.put("paymentObjectId", paymentObjectId);
      map.put("paymentObject", paymentObject);
      map.put("applyPaymentAmount", applyPaymentAmount);
      map.put("applyPaidAmount", applyPaidAmount);
      map.put("orderAmount", orderAmount);
      map.put("invoiceAmount", invoiceAmount);
      map.put("prepaymentAmount", prepaymentAmount);
      map.put("collectionAccumulation", collectionAccumulation);
      map.put("paymentAccumulation", paymentAccumulation);
      map.put("prepaymentRequestNo", prepaymentRequestNo);
      map.put("prepaymentPaymentVoucher", prepaymentPaymentVoucher);
      map.put("prepaymentWriteVoucher", prepaymentWriteVoucher);
      map.put("paymentVoucher", paymentVoucher);
      map.put("paymentPaymentVoucher", paymentPaymentVoucher);
      map.put("paymentClearingVoucher", paymentClearingVoucher);
      map.put("currentStatus", currentStatus);
      map.put("errorInfo", errorInfo);
      map.put("profitCenter", profitCenter);
      map.put("costCenter", costCenter);
      map.put("paymentUserType", paymentUserType);
      map.put("paymentDueDate", BocpGenUtils.toTimestamp(paymentDueDate));
      map.put("paymentBankType", paymentBankType);
      map.put("collectionBank", collectionBank);
      map.put("collectionAccount", collectionAccount);
      map.put("collectionName", collectionName);
      map.put("contractNo", contractNo);
      map.put("contractName", contractName);
      map.put("contractAmount", contractAmount);
      map.put("contractType", contractType);
      map.put("startDate", BocpGenUtils.toTimestamp(startDate));
      map.put("endDate", BocpGenUtils.toTimestamp(endDate));
      map.put("file", file);
      map.put("text", text);
      map.put("paymentRemark", paymentRemark);
      map.put("approvalHistory", approvalHistory);
      map.put("downloadUserName", downloadUserName);
      map.put("downloadStatus", downloadStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("contractSignDate", BocpGenUtils.toTimestamp(contractSignDate));
      map.put("fileUrl", fileUrl);
      map.put("fileName", fileName);
      map.put("invoiceNoticeNOs", invoiceNoticeNOs);
      map.put("approvalRole", approvalRole);
      map.put("poNos", poNos);
      map.put("companyId", companyId);
      map.put("companyName", companyName);
      map.put("purchaserId", purchaserId);
      map.put("purchaserName", purchaserName);
      return map;
  }

  public static PaymentManage fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PaymentManage entity = new PaymentManage();
    if(map.containsKey("applyId")) {
      Object obj = map.get("applyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUserName")) {
      Object obj = map.get("applyUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentType")) {
      Object obj = map.get("prepaymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agencyFeeType")) {
      Object obj = map.get("agencyFeeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAgencyFeeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bondType")) {
      Object obj = map.get("bondType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBondType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("changeTicketType")) {
      Object obj = map.get("changeTicketType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChangeTicketType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementGroup")) {
      Object obj = map.get("procurementGroup");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentObjectId")) {
      Object obj = map.get("paymentObjectId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentObjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentObject")) {
      Object obj = map.get("paymentObject");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentObject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyPaymentAmount")) {
      Object obj = map.get("applyPaymentAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyPaymentAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyPaidAmount")) {
      Object obj = map.get("applyPaidAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyPaidAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderAmount")) {
      Object obj = map.get("orderAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmount")) {
      Object obj = map.get("invoiceAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentAmount")) {
      Object obj = map.get("prepaymentAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccumulation")) {
      Object obj = map.get("collectionAccumulation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionAccumulation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentAccumulation")) {
      Object obj = map.get("paymentAccumulation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentAccumulation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentRequestNo")) {
      Object obj = map.get("prepaymentRequestNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentRequestNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentPaymentVoucher")) {
      Object obj = map.get("prepaymentPaymentVoucher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentPaymentVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentWriteVoucher")) {
      Object obj = map.get("prepaymentWriteVoucher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentWriteVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentVoucher")) {
      Object obj = map.get("paymentVoucher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentPaymentVoucher")) {
      Object obj = map.get("paymentPaymentVoucher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentPaymentVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentClearingVoucher")) {
      Object obj = map.get("paymentClearingVoucher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentClearingVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currentStatus")) {
      Object obj = map.get("currentStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorInfo")) {
      Object obj = map.get("errorInfo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setErrorInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profitCenter")) {
      Object obj = map.get("profitCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProfitCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentUserType")) {
      Object obj = map.get("paymentUserType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentUserType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentDueDate")) {
      Object obj = map.get("paymentDueDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDueDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaymentDueDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaymentDueDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentDueDate(null);
      }
    }
    if(map.containsKey("paymentBankType")) {
      Object obj = map.get("paymentBankType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentBankType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionBank")) {
      Object obj = map.get("collectionBank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionName")) {
      Object obj = map.get("collectionName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractName")) {
      Object obj = map.get("contractName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractAmount")) {
      Object obj = map.get("contractAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractType")) {
      Object obj = map.get("contractType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startDate")) {
      Object obj = map.get("startDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartDate(null);
      }
    }
    if(map.containsKey("endDate")) {
      Object obj = map.get("endDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndDate(null);
      }
    }
    if(map.containsKey("file")) {
      Object obj = map.get("file");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFile((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("text")) {
      Object obj = map.get("text");
      if(obj != null) {
        if(obj instanceof String){
          entity.setText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentRemark")) {
      Object obj = map.get("paymentRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approvalHistory")) {
      Object obj = map.get("approvalHistory");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalHistory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("downloadUserName")) {
      Object obj = map.get("downloadUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloadUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("downloadStatus")) {
      Object obj = map.get("downloadStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloadStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractSignDate")) {
      Object obj = map.get("contractSignDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setContractSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setContractSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setContractSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setContractSignDate(null);
      }
    }
    if(map.containsKey("fileUrl")) {
      Object obj = map.get("fileUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fileName")) {
      Object obj = map.get("fileName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeNOs")) {
      Object obj = map.get("invoiceNoticeNOs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNoticeNOs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approvalRole")) {
      Object obj = map.get("approvalRole");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalRole((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNos")) {
      Object obj = map.get("poNos");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNos((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyId")) {
      Object obj = map.get("companyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserId")) {
      Object obj = map.get("purchaserId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
