package com.xforceplus.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票状态
 * </p>
 *
 * @author ultraman
 * @since 2022-04-22
 */
public enum InvoiceRegisterStatus {

    _0("0", "作废"),
    _1("1", "正常"),
    _6("6", "失控");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceRegisterStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceRegisterStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
