package com.xforceplus.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 付款银行类型
 * </p>
 *
 * @author ultraman
 * @since 2022-03-24
 */
public enum PaymentBankType {

    _0("0", "默认"),
    _1("1", "总部DB"),
    _2("2", "分公司DB"),
    _3("3", "分公司基本户"),
    _4("4", "总部ICBC"),
    _5("5", "总部CMB南西支行");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PaymentBankType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PaymentBankType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
