package com.xforceplus.jctke.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-05-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaseInitFailedHistory implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 订单号
   */
  @TableField("poNumber")
  private String poNumber;

  /**
   * 批准标识
   */
  @TableField("approvalLogo")
  private String approvalLogo;

  /**
   * 采购组
   */
  @TableField("purchaserGroup")
  private String purchaserGroup;

  /**
   * 凭证日期
   */
  @TableField("voucherDate")
  private String voucherDate;

  /**
   * 供应商/供应工厂
   */
  private String seller;

  /**
   * 物料
   */
  private String material;

  /**
   * 短文本
   */
  @TableField("shortText")
  private String shortText;

  /**
   * 物料组
   */
  @TableField("materialGroup")
  private String materialGroup;

  /**
   * 税码
   */
  @TableField("taxCode")
  private String taxCode;

  /**
   * 删除标识
   */
  @TableField("deleteStatus")
  private String deleteStatus;

  /**
   * 科目分配类别
   */
  @TableField("subjectAllocationType")
  private String subjectAllocationType;

  /**
   * 工厂
   */
  private String factory;

  /**
   * 采购订单数量
   */
  @TableField("purchaseOrderQuantity")
  private String purchaseOrderQuantity;

  /**
   * 订单单位
   */
  @TableField("orderUnit")
  private String orderUnit;

  /**
   * 净价
   */
  @TableField("netPrice")
  private String netPrice;

  /**
   * 货币
   */
  private String currency;

  /**
   * 价格单位
   */
  @TableField("priceUnit")
  private String priceUnit;

  /**
   * 仍要交货(数量)
   */
  @TableField("stillDeliveredQuantity")
  private String stillDeliveredQuantity;

  /**
   * 仍要交货(价值)
   */
  @TableField("stillDeliveredPrice")
  private String stillDeliveredPrice;

  /**
   * 仍要开票(数量)
   */
  @TableField("stillinvoicedQuantity")
  private String stillinvoicedQuantity;

  /**
   * 仍要开票(价值)
   */
  @TableField("stillinvoicedPrice")
  private String stillinvoicedPrice;

  /**
   * 发布状态
   */
  @TableField("postStatus")
  private String postStatus;

  /**
   * 创建日期
   */
  @TableField("createDate")
  private String createDate;

  /**
   * 创建者
   */
  @TableField("createUser")
  private String createUser;

  /**
   * 采购组织
   */
  @TableField("purchaserOrg")
  private String purchaserOrg;

  /**
   * 公司代码
   */
  @TableField("companyCode")
  private String companyCode;

  /**
   * 存储位置
   */
  @TableField("storageLocation")
  private String storageLocation;

  /**
   * 项目类别
   */
  @TableField("itemClassification")
  private String itemClassification;

  /**
   * 订单价格单位
   */
  @TableField("orderPriceUnit")
  private String orderPriceUnit;

  /**
   * 订单净值
   */
  @TableField("netValueOfTheOrder")
  private String netValueOfTheOrder;

  /**
   * 订单总价值
   */
  @TableField("totalValueOfOrder")
  private String totalValueOfOrder;

  /**
   * 交货已完成
   */
  @TableField("deliveryCompleted")
  private String deliveryCompleted;

  /**
   * 最后发票
   */
  @TableField("finalInvoice")
  private String finalInvoice;

  /**
   * 评估类型
   */
  @TableField("assessmentType")
  private String assessmentType;

  /**
   * SqNoAccAss
   */
  @TableField("sqNoAccAss")
  private String sqNoAccAss;

  /**
   * 分配(%)
   */
  private String distribution;

  /**
   * 总帐科目
   */
  @TableField("generalLedgerAccount")
  private String generalLedgerAccount;

  /**
   * 业务范围
   */
  @TableField("businessScope")
  private String businessScope;

  /**
   * 成本中心
   */
  @TableField("costCenter")
  private String costCenter;

  /**
   * 订单
   */
  private String order;

  /**
   * 利润中心
   */
  @TableField("profitCenter")
  private String profitCenter;

  /**
   * WBS要素
   */
  private String webs;

  /**
   * 网络
   */
  private String network;

  /**
   * 设备
   */
  private String equipment;

  /**
   * 序列号
   */
  @TableField("serialNumber")
  private String serialNumber;

  /**
   * 当前客户
   */
  @TableField("currentCustomer")
  private String currentCustomer;

  /**
   * 主键缺失
   */
  @TableField("isPrimaryKeyAbsent")
  private Boolean isPrimaryKeyAbsent;

  /**
   * 必填项缺失
   */
  @TableField("isRequiredAbsent")
  private Boolean isRequiredAbsent;

  /**
   * 缺失信息描述
   */
  @TableField("absentMsg")
  private String absentMsg;

  /**
   * 供应商号
   */
  @TableField("sellerNo")
  private String sellerNo;

  /**
   * 供应商名
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 付款方式
   */
  @TableField("paymentTerm")
  private String paymentTerm;

  /**
   * 分公司名
   */
  @TableField("buyerName")
  private String buyerName;

  /**
   * 开票地址
   */
  @TableField("licenseAddress")
  private String licenseAddress;

  /**
   * 业务类型
   */
  @TableField("businessType")
  private String businessType;

  /**
   * 订单不含税总金额
   */
  private String amount;

  /**
   * 已付款金额
   */
  @TableField("payedAmount")
  private String payedAmount;

  /**
   * 已开票金额
   */
  @TableField("invoicedAmount")
  private String invoicedAmount;

  /**
   * 待开票金额
   */
  @TableField("waitForInvoiceAmount")
  private String waitForInvoiceAmount;

  /**
   * 已收货金额
   */
  @TableField("deliveriedAmount")
  private String deliveriedAmount;

  /**
   * 预付金额
   */
  @TableField("prepayAmount")
  private String prepayAmount;

  /**
   * 未付金额
   */
  @TableField("unpayedAmount")
  private String unpayedAmount;

  /**
   * 分公司ID
   */
  @TableField("buyerID")
  private String buyerID;

  /**
   * 失败原因
   */
  @TableField("failureReason")
  private String failureReason;

  /**
   * 采购组
   */
  @TableField("purchasingTeam")
  private String purchasingTeam;

  /**
   * 采购组织
   */
  @TableField("purchasingOrg")
  private String purchasingOrg;

  /**
   * 已预付待核销金额
   */
  @TableField("prepaidAmount")
  private String prepaidAmount;

  /**
   * 分公司发票ID
   */
  @TableField("buyerInvoiceID")
  private String buyerInvoiceID;

  /**
   * 分公司发票抬头
   */
  @TableField("buyerInvoiceTitle")
  private String buyerInvoiceTitle;

  /**
   * 订单含税总金额
   */
  @TableField("amountWithTax")
  private String amountWithTax;

  /**
   * 是否是协同供应商
   */
  @TableField("isCoord")
  private String isCoord;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 供应商税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 购方编号
   */
  @TableField("purchaserNo")
  private String purchaserNo;

  /**
   * 结算单号
   */
  @TableField("businessOrderNo")
  private String businessOrderNo;

  /**
   * 物料/服务
   */
  @TableField("materialServices")
  private String materialServices;

  /**
   * 数量
   */
  private String quantity;

  /**
   * 单位
   */
  private String uom;

  /**
   * 要求送货日期
   */
  @TableField("reqDelDate")
  private String reqDelDate;

  /**
   * 不含税单价
   */
  @TableField("netPriceExVAT")
  private String netPriceExVAT;

  /**
   * 价格单位
   */
  @TableField("perUoM")
  private String perUoM;

  /**
   * 增值税率
   */
  @TableField("vatRate")
  private String vatRate;

  /**
   * 含税小计
   */
  @TableField("totalAmountCNY")
  private String totalAmountCNY;

  /**
   * WBS
   */
  private String wbs;

  /**
   * 物料/服务名称
   */
  @TableField("materialServicesName")
  private String materialServicesName;

  /**
   * 梯号
   */
  @TableField("ladderNo")
  private String ladderNo;

  /**
   * 合同号
   */
  @TableField("contractID")
  private String contractID;

  /**
   * 项目名称
   */
  @TableField("projectName")
  private String projectName;

  /**
   * 梯台状态ID
   */
  @TableField("ladderStatusID")
  private String ladderStatusID;

  /**
   * 梯台状态
   */
  @TableField("ladderStatus")
  private String ladderStatus;

  /**
   * 税码
   */
  @TableField("vatCode")
  private String vatCode;

  /**
   * 物料组
   */
  @TableField("materialServicesTeam")
  private String materialServicesTeam;

  /**
   * 利润中心
   */
  @TableField("profitsCenter")
  private String profitsCenter;

  /**
   * View业务系统
   */
  @TableField("viewId")
  private String viewId;

  /**
   * 已收货数量
   */
  @TableField("receivedCount")
  private String receivedCount;

  /**
   * 审批状态
   */
  @TableField("releaseStatus")
  private String releaseStatus;

  /**
   * PM节点
   */
  @TableField("pmNode")
  private String pmNode;

  /**
   * 订单状态
   */
  @TableField("orderStatus")
  private String orderStatus;

  /**
   * 订单类型
   */
  @TableField("orderType")
  private String orderType;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 行号
   */
  private Long item;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("poNumber", poNumber);
      map.put("approvalLogo", approvalLogo);
      map.put("purchaserGroup", purchaserGroup);
      map.put("voucherDate", voucherDate);
      map.put("seller", seller);
      map.put("material", material);
      map.put("shortText", shortText);
      map.put("materialGroup", materialGroup);
      map.put("taxCode", taxCode);
      map.put("deleteStatus", deleteStatus);
      map.put("subjectAllocationType", subjectAllocationType);
      map.put("factory", factory);
      map.put("purchaseOrderQuantity", purchaseOrderQuantity);
      map.put("orderUnit", orderUnit);
      map.put("netPrice", netPrice);
      map.put("currency", currency);
      map.put("priceUnit", priceUnit);
      map.put("stillDeliveredQuantity", stillDeliveredQuantity);
      map.put("stillDeliveredPrice", stillDeliveredPrice);
      map.put("stillinvoicedQuantity", stillinvoicedQuantity);
      map.put("stillinvoicedPrice", stillinvoicedPrice);
      map.put("postStatus", postStatus);
      map.put("createDate", createDate);
      map.put("createUser", createUser);
      map.put("purchaserOrg", purchaserOrg);
      map.put("companyCode", companyCode);
      map.put("storageLocation", storageLocation);
      map.put("itemClassification", itemClassification);
      map.put("orderPriceUnit", orderPriceUnit);
      map.put("netValueOfTheOrder", netValueOfTheOrder);
      map.put("totalValueOfOrder", totalValueOfOrder);
      map.put("deliveryCompleted", deliveryCompleted);
      map.put("finalInvoice", finalInvoice);
      map.put("assessmentType", assessmentType);
      map.put("sqNoAccAss", sqNoAccAss);
      map.put("distribution", distribution);
      map.put("generalLedgerAccount", generalLedgerAccount);
      map.put("businessScope", businessScope);
      map.put("costCenter", costCenter);
      map.put("order", order);
      map.put("profitCenter", profitCenter);
      map.put("webs", webs);
      map.put("network", network);
      map.put("equipment", equipment);
      map.put("serialNumber", serialNumber);
      map.put("currentCustomer", currentCustomer);
      map.put("isPrimaryKeyAbsent", isPrimaryKeyAbsent);
      map.put("isRequiredAbsent", isRequiredAbsent);
      map.put("absentMsg", absentMsg);
      map.put("sellerNo", sellerNo);
      map.put("sellerName", sellerName);
      map.put("paymentTerm", paymentTerm);
      map.put("buyerName", buyerName);
      map.put("licenseAddress", licenseAddress);
      map.put("businessType", businessType);
      map.put("amount", amount);
      map.put("payedAmount", payedAmount);
      map.put("invoicedAmount", invoicedAmount);
      map.put("waitForInvoiceAmount", waitForInvoiceAmount);
      map.put("deliveriedAmount", deliveriedAmount);
      map.put("prepayAmount", prepayAmount);
      map.put("unpayedAmount", unpayedAmount);
      map.put("buyerID", buyerID);
      map.put("failureReason", failureReason);
      map.put("purchasingTeam", purchasingTeam);
      map.put("purchasingOrg", purchasingOrg);
      map.put("prepaidAmount", prepaidAmount);
      map.put("buyerInvoiceID", buyerInvoiceID);
      map.put("buyerInvoiceTitle", buyerInvoiceTitle);
      map.put("amountWithTax", amountWithTax);
      map.put("isCoord", isCoord);
      map.put("invoiceType", invoiceType);
      map.put("purchaserName", purchaserName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("purchaserNo", purchaserNo);
      map.put("businessOrderNo", businessOrderNo);
      map.put("materialServices", materialServices);
      map.put("quantity", quantity);
      map.put("uom", uom);
      map.put("reqDelDate", reqDelDate);
      map.put("netPriceExVAT", netPriceExVAT);
      map.put("perUoM", perUoM);
      map.put("vatRate", vatRate);
      map.put("totalAmountCNY", totalAmountCNY);
      map.put("wbs", wbs);
      map.put("materialServicesName", materialServicesName);
      map.put("ladderNo", ladderNo);
      map.put("contractID", contractID);
      map.put("projectName", projectName);
      map.put("ladderStatusID", ladderStatusID);
      map.put("ladderStatus", ladderStatus);
      map.put("vatCode", vatCode);
      map.put("materialServicesTeam", materialServicesTeam);
      map.put("profitsCenter", profitsCenter);
      map.put("viewId", viewId);
      map.put("receivedCount", receivedCount);
      map.put("releaseStatus", releaseStatus);
      map.put("pmNode", pmNode);
      map.put("orderStatus", orderStatus);
      map.put("orderType", orderType);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("item", item);
      return map;
  }

  public static PurchaseInitFailedHistory fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaseInitFailedHistory entity = new PurchaseInitFailedHistory();
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approvalLogo")) {
      Object obj = map.get("approvalLogo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalLogo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserGroup")) {
      Object obj = map.get("purchaserGroup");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucherDate")) {
      Object obj = map.get("voucherDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucherDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller")) {
      Object obj = map.get("seller");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSeller((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("material")) {
      Object obj = map.get("material");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterial((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shortText")) {
      Object obj = map.get("shortText");
      if(obj != null) {
        if(obj instanceof String){
          entity.setShortText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialGroup")) {
      Object obj = map.get("materialGroup");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCode")) {
      Object obj = map.get("taxCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deleteStatus")) {
      Object obj = map.get("deleteStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subjectAllocationType")) {
      Object obj = map.get("subjectAllocationType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubjectAllocationType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("factory")) {
      Object obj = map.get("factory");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFactory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseOrderQuantity")) {
      Object obj = map.get("purchaseOrderQuantity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseOrderQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderUnit")) {
      Object obj = map.get("orderUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netPrice")) {
      Object obj = map.get("netPrice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNetPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceUnit")) {
      Object obj = map.get("priceUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPriceUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stillDeliveredQuantity")) {
      Object obj = map.get("stillDeliveredQuantity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStillDeliveredQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stillDeliveredPrice")) {
      Object obj = map.get("stillDeliveredPrice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStillDeliveredPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stillinvoicedQuantity")) {
      Object obj = map.get("stillinvoicedQuantity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStillinvoicedQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stillinvoicedPrice")) {
      Object obj = map.get("stillinvoicedPrice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStillinvoicedPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postStatus")) {
      Object obj = map.get("postStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPostStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createDate")) {
      Object obj = map.get("createDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createUser")) {
      Object obj = map.get("createUser");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserOrg")) {
      Object obj = map.get("purchaserOrg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storageLocation")) {
      Object obj = map.get("storageLocation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStorageLocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemClassification")) {
      Object obj = map.get("itemClassification");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemClassification((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderPriceUnit")) {
      Object obj = map.get("orderPriceUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderPriceUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netValueOfTheOrder")) {
      Object obj = map.get("netValueOfTheOrder");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNetValueOfTheOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalValueOfOrder")) {
      Object obj = map.get("totalValueOfOrder");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalValueOfOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryCompleted")) {
      Object obj = map.get("deliveryCompleted");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeliveryCompleted((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("finalInvoice")) {
      Object obj = map.get("finalInvoice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFinalInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assessmentType")) {
      Object obj = map.get("assessmentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAssessmentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sqNoAccAss")) {
      Object obj = map.get("sqNoAccAss");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSqNoAccAss((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distribution")) {
      Object obj = map.get("distribution");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDistribution((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generalLedgerAccount")) {
      Object obj = map.get("generalLedgerAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGeneralLedgerAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessScope")) {
      Object obj = map.get("businessScope");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessScope((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order")) {
      Object obj = map.get("order");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profitCenter")) {
      Object obj = map.get("profitCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProfitCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("webs")) {
      Object obj = map.get("webs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWebs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("network")) {
      Object obj = map.get("network");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNetwork((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("equipment")) {
      Object obj = map.get("equipment");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEquipment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serialNumber")) {
      Object obj = map.get("serialNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSerialNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currentCustomer")) {
      Object obj = map.get("currentCustomer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrentCustomer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isPrimaryKeyAbsent")) {
      Object obj = map.get("isPrimaryKeyAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsPrimaryKeyAbsent((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsPrimaryKeyAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("isRequiredAbsent")) {
      Object obj = map.get("isRequiredAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsRequiredAbsent((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsRequiredAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAbsentMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentTerm")) {
      Object obj = map.get("paymentTerm");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentTerm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("licenseAddress")) {
      Object obj = map.get("licenseAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLicenseAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payedAmount")) {
      Object obj = map.get("payedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicedAmount")) {
      Object obj = map.get("invoicedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("waitForInvoiceAmount")) {
      Object obj = map.get("waitForInvoiceAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWaitForInvoiceAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveriedAmount")) {
      Object obj = map.get("deliveriedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeliveriedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepayAmount")) {
      Object obj = map.get("prepayAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepayAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unpayedAmount")) {
      Object obj = map.get("unpayedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnpayedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("failureReason")) {
      Object obj = map.get("failureReason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFailureReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingTeam")) {
      Object obj = map.get("purchasingTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchasingTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingOrg")) {
      Object obj = map.get("purchasingOrg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchasingOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaidAmount")) {
      Object obj = map.get("prepaidAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaidAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceID")) {
      Object obj = map.get("buyerInvoiceID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerInvoiceID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceTitle")) {
      Object obj = map.get("buyerInvoiceTitle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerInvoiceTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isCoord")) {
      Object obj = map.get("isCoord");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsCoord((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessOrderNo")) {
      Object obj = map.get("businessOrderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServices")) {
      Object obj = map.get("materialServices");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServices((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uom")) {
      Object obj = map.get("uom");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reqDelDate")) {
      Object obj = map.get("reqDelDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReqDelDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netPriceExVAT")) {
      Object obj = map.get("netPriceExVAT");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNetPriceExVAT((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("perUoM")) {
      Object obj = map.get("perUoM");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPerUoM((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatRate")) {
      Object obj = map.get("vatRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVatRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmountCNY")) {
      Object obj = map.get("totalAmountCNY");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAmountCNY((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWbs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesName")) {
      Object obj = map.get("materialServicesName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServicesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderNo")) {
      Object obj = map.get("ladderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractID")) {
      Object obj = map.get("contractID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderStatusID")) {
      Object obj = map.get("ladderStatusID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderStatusID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderStatus")) {
      Object obj = map.get("ladderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatCode")) {
      Object obj = map.get("vatCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVatCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesTeam")) {
      Object obj = map.get("materialServicesTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServicesTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profitsCenter")) {
      Object obj = map.get("profitsCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProfitsCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("viewId")) {
      Object obj = map.get("viewId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setViewId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivedCount")) {
      Object obj = map.get("receivedCount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceivedCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("releaseStatus")) {
      Object obj = map.get("releaseStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReleaseStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pmNode")) {
      Object obj = map.get("pmNode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPmNode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setItem((Long)obj);
        } else if(obj instanceof String) {
          entity.setItem(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setItem(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    return entity;
  }
}
