package com.xforceplus.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 当前状态
 * </p>
 *
 * @author ultraman
 * @since 2022-05-14
 */
public enum CurrentStatus {

    _0("0", "草稿"),
    _1("1", "待分公司确认"),
    _2("2", "待分公司安装部确认"),
    _3("3", "待分公司分总确认"),
    _4("4", "待区域财务确认"),
    _5("5", "待总部财务确认"),
    _6("6", "已提交待支付"),
    _7("7", "已支付"),
    _8("8", "已锁定"),
    _9("9", "已冲销"),
    _10("10", "应付凭证已取消"),
    _11("11", "已驳回"),
    _12("12", "等待配单发票"),
    _13("13", "已核销"),
    _14("14", "待系统提交");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CurrentStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CurrentStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            default:
                return null;
        }
    }
}
