package com.xforceplus.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票来源
 * </p>
 *
 * @author ultraman
 * @since 2022-05-17
 */
public enum InvoiceSource {

    IMAGE_SYNC_BILL_TICKET("image.syncBillTicket", "影像单据整单"),
    PHOENIX_DISCERN_DATA("phoenix.discern.data", "影像单张单证"),
    INVOICE_NOTIFY_EVENTV4("invoice_notify_eventv4", "协同平台");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceSource fromCode(String code){
        switch(code) {
            case "image.syncBillTicket":
                return IMAGE_SYNC_BILL_TICKET;
            case "phoenix.discern.data":
                return PHOENIX_DISCERN_DATA;
            case "invoice_notify_eventv4":
                return INVOICE_NOTIFY_EVENTV4;
            default:
                return null;
        }
    }
}
