package com.xforceplus.jctke.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 预付单
 * </p>
 *
 * @author ultraman
 * @since 2022-06-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Imprest implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 申请id
   */
  private String applyId;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 付款单类型
   */
  private String paymentOrderType;

  /**
   * 前置业务类型
   */
  private String preBusinessType;

  /**
   * 付款ID
   */
  private String payId;

  /**
   * 付款对象
   */
  private String payer;

  /**
   * 付款银行类型
   */
  private String payBankType;

  /**
   * 付款备注
   */
  private String payRemark;

  /**
   * 录入SAP的文本
   */
  private String entrySapText;

  /**
   * 附件
   */
  private String attachmentUrl;

  /**
   * 状态
   */
  private String status;

  /**
   * 预付款凭证号
   */
  private String imprestVoucherNo;

  /**
   * 下载人Id
   */
  private String downloadUserId;

  /**
   * 下载人
   */
  private String downloadUserName;

  /**
   * 下载状态
   */
  private String downloadStatus;

  /**
   * 付款到期日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime payLastDate;

  /**
   * 当前审批人
   */
  private String currentApprover;

  /**
   * 审批历史
   */
  private String approvalRecord;

  /**
   * 付款单的其它备注信息
   */
  private String otherRemark;

  /**
   * 业务单号
   */
  private String billNo;

  /**
   * 异常信息
   */
  private String errorMsg;

  /**
   * 预付类型
   */
  private String imprestType;

  /**
   * 收款银行账号
   */
  private String payeeBankAccount;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("apply_id", applyId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("payment_order_type", paymentOrderType);
      map.put("pre_business_type", preBusinessType);
      map.put("pay_id", payId);
      map.put("payer", payer);
      map.put("pay_bank_type", payBankType);
      map.put("pay_remark", payRemark);
      map.put("entry_sap_text", entrySapText);
      map.put("attachment_url", attachmentUrl);
      map.put("status", status);
      map.put("imprest_voucher_no", imprestVoucherNo);
      map.put("download_user_id", downloadUserId);
      map.put("download_user_name", downloadUserName);
      map.put("download_status", downloadStatus);
      map.put("pay_last_date", BocpGenUtils.toTimestamp(payLastDate));
      map.put("current_approver", currentApprover);
      map.put("approval_record", approvalRecord);
      map.put("other_remark", otherRemark);
      map.put("bill_no", billNo);
      map.put("error_msg", errorMsg);
      map.put("imprest_type", imprestType);
      map.put("payee_bank_account", payeeBankAccount);
      return map;
  }

  public static Imprest fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Imprest entity = new Imprest();
    if(map.containsKey("apply_id")) {
      Object obj = map.get("apply_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_order_type")) {
      Object obj = map.get("payment_order_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pre_business_type")) {
      Object obj = map.get("pre_business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_id")) {
      Object obj = map.get("pay_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payer")) {
      Object obj = map.get("payer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_bank_type")) {
      Object obj = map.get("pay_bank_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayBankType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_remark")) {
      Object obj = map.get("pay_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entry_sap_text")) {
      Object obj = map.get("entry_sap_text");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntrySapText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attachment_url")) {
      Object obj = map.get("attachment_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAttachmentUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("imprest_voucher_no")) {
      Object obj = map.get("imprest_voucher_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImprestVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("download_user_id")) {
      Object obj = map.get("download_user_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloadUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("download_user_name")) {
      Object obj = map.get("download_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloadUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("download_status")) {
      Object obj = map.get("download_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloadStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_last_date")) {
      Object obj = map.get("pay_last_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayLastDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPayLastDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPayLastDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPayLastDate(null);
      }
    }
    if(map.containsKey("current_approver")) {
      Object obj = map.get("current_approver");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrentApprover((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_record")) {
      Object obj = map.get("approval_record");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalRecord((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("other_remark")) {
      Object obj = map.get("other_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOtherRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_no")) {
      Object obj = map.get("bill_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("imprest_type")) {
      Object obj = map.get("imprest_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImprestType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee_bank_account")) {
      Object obj = map.get("payee_bank_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayeeBankAccount((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
