package com.xforceplus.jctke.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-07-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AgentFeeReport implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务线
   */
  @TableField("loB")
  private String loB;

  /**
   * 销售区域
   */
  @TableField("salesRegion")
  private String salesRegion;

  /**
   * 执行区域
   */
  @TableField("executionRegion")
  private String executionRegion;

  /**
   * 项目中文名称
   */
  @TableField("projectNameZh")
  private String projectNameZh;

  /**
   * 项目英文名称
   */
  @TableField("projectNameEn")
  private String projectNameEn;

  /**
   * 销售渠道
   */
  @TableField("salesChannel")
  private String salesChannel;

  /**
   * 销售分公司
   */
  @TableField("salesBranchEn")
  private String salesBranchEn;

  /**
   * 执行分公司
   */
  @TableField("executionBranchEn")
  private String executionBranchEn;

  /**
   * 跨分公司项目标记
   */
  @TableField("ifCrossBranchProject")
  private String ifCrossBranchProject;

  /**
   * 首次OI时间
   */
  @TableField("firstOIDate")
  private String firstOIDate;

  /**
   * 销售分公司VIEW项目号
   */
  @TableField("salesBranchVIEWProjectId")
  private String salesBranchVIEWProjectId;

  /**
   * 执行分公司VIEW项目号
   */
  @TableField("executionBranchVIEWProjectId")
  private String executionBranchVIEWProjectId;

  /**
   * Daproh项目编码
   */
  @TableField("daprohProjectId")
  private String daprohProjectId;

  /**
   * Daproh系统的VIEW项目编码
   */
  @TableField("daprohVIEWProjectId")
  private String daprohVIEWProjectId;

  /**
   * 项目状态
   */
  @TableField("projectStatus")
  private String projectStatus;

  /**
   * 代理商名称
   */
  @TableField("agentSupplierName")
  private String agentSupplierName;

  /**
   * 代理商GMDS编码
   */
  @TableField("agentSupplierGMDSNo")
  private String agentSupplierGMDSNo;

  /**
   * 项目设备合同额(排除VO)
   */
  @TableField("projectEquipmentContractValue")
  private String projectEquipmentContractValue;

  /**
   * 项目设备收款额(排除VO)
   */
  @TableField("totalProjectCollectedMoney")
  private String totalProjectCollectedMoney;

  /**
   * 项目设备收款比例
   */
  @TableField("collectionPercent")
  private String collectionPercent;

  /**
   * VO合同金额
   */
  @TableField("contractAmountVo")
  private String contractAmountVo;

  /**
   * VO收款金额
   */
  @TableField("collectionAmountVo")
  private String collectionAmountVo;

  /**
   * VO收款比例
   */
  @TableField("collectionPercentVo")
  private String collectionPercentVo;

  /**
   * 代理费采购订单编码
   */
  @TableField("agentFeePoNumber")
  private String agentFeePoNumber;

  /**
   * 代理费采购订单金额
   */
  @TableField("totalAgentFeePoAmount")
  private String totalAgentFeePoAmount;

  /**
   * 代理费累计可支付代理商金额
   */
  @TableField("totalAccumulativePayableAgentFee")
  private String totalAccumulativePayableAgentFee;

  /**
   * PO状态
   */
  @TableField("poStatus")
  private String poStatus;

  /**
   * 代理费累计收货金额
   */
  @TableField("totalAgentFeeGRAmount")
  private String totalAgentFeeGRAmount;

  /**
   * 代理费累计发票校验金额
   */
  @TableField("totalVerifiedAgentFeeInvoiceAmountIR")
  private String totalVerifiedAgentFeeInvoiceAmountIR;

  /**
   * 代理费最后一次开票日期
   */
  @TableField("agentFeeLastInvoiceDate")
  private String agentFeeLastInvoiceDate;

  /**
   * 代理费收货和发票的一致性检查
   */
  @TableField("agentFeeInvoiceGrCheck")
  private String agentFeeInvoiceGrCheck;

  /**
   * 代理商发票开具进度
   */
  @TableField("invoiceStatus")
  private String invoiceStatus;

  /**
   * light
   */
  private String light;

  /**
   * 代理费含税采购订单金额
   */
  @TableField("agentFeePoAmountWithTax")
  private String agentFeePoAmountWithTax;

  /**
   * 代理费含税的收货金额
   */
  @TableField("agentFeeTotalGRAmountWithTax")
  private String agentFeeTotalGRAmountWithTax;

  /**
   * 含税累计可支付代理商金额
   */
  @TableField("totalAccumulativePayableAgentFeeWithTax")
  private String totalAccumulativePayableAgentFeeWithTax;

  /**
   * 含税发票校验金额
   */
  @TableField("totalVerifiedInvoiceAmountIrWithTax")
  private String totalVerifiedInvoiceAmountIrWithTax;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("loB", loB);
      map.put("salesRegion", salesRegion);
      map.put("executionRegion", executionRegion);
      map.put("projectNameZh", projectNameZh);
      map.put("projectNameEn", projectNameEn);
      map.put("salesChannel", salesChannel);
      map.put("salesBranchEn", salesBranchEn);
      map.put("executionBranchEn", executionBranchEn);
      map.put("ifCrossBranchProject", ifCrossBranchProject);
      map.put("firstOIDate", firstOIDate);
      map.put("salesBranchVIEWProjectId", salesBranchVIEWProjectId);
      map.put("executionBranchVIEWProjectId", executionBranchVIEWProjectId);
      map.put("daprohProjectId", daprohProjectId);
      map.put("daprohVIEWProjectId", daprohVIEWProjectId);
      map.put("projectStatus", projectStatus);
      map.put("agentSupplierName", agentSupplierName);
      map.put("agentSupplierGMDSNo", agentSupplierGMDSNo);
      map.put("projectEquipmentContractValue", projectEquipmentContractValue);
      map.put("totalProjectCollectedMoney", totalProjectCollectedMoney);
      map.put("collectionPercent", collectionPercent);
      map.put("contractAmountVo", contractAmountVo);
      map.put("collectionAmountVo", collectionAmountVo);
      map.put("collectionPercentVo", collectionPercentVo);
      map.put("agentFeePoNumber", agentFeePoNumber);
      map.put("totalAgentFeePoAmount", totalAgentFeePoAmount);
      map.put("totalAccumulativePayableAgentFee", totalAccumulativePayableAgentFee);
      map.put("poStatus", poStatus);
      map.put("totalAgentFeeGRAmount", totalAgentFeeGRAmount);
      map.put("totalVerifiedAgentFeeInvoiceAmountIR", totalVerifiedAgentFeeInvoiceAmountIR);
      map.put("agentFeeLastInvoiceDate", agentFeeLastInvoiceDate);
      map.put("agentFeeInvoiceGrCheck", agentFeeInvoiceGrCheck);
      map.put("invoiceStatus", invoiceStatus);
      map.put("light", light);
      map.put("agentFeePoAmountWithTax", agentFeePoAmountWithTax);
      map.put("agentFeeTotalGRAmountWithTax", agentFeeTotalGRAmountWithTax);
      map.put("totalAccumulativePayableAgentFeeWithTax", totalAccumulativePayableAgentFeeWithTax);
      map.put("totalVerifiedInvoiceAmountIrWithTax", totalVerifiedInvoiceAmountIrWithTax);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static AgentFeeReport fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    AgentFeeReport entity = new AgentFeeReport();
    if(map.containsKey("loB")) {
      Object obj = map.get("loB");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLoB((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesRegion")) {
      Object obj = map.get("salesRegion");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("executionRegion")) {
      Object obj = map.get("executionRegion");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExecutionRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNameZh")) {
      Object obj = map.get("projectNameZh");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectNameZh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNameEn")) {
      Object obj = map.get("projectNameEn");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectNameEn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesChannel")) {
      Object obj = map.get("salesChannel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesBranchEn")) {
      Object obj = map.get("salesBranchEn");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesBranchEn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("executionBranchEn")) {
      Object obj = map.get("executionBranchEn");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExecutionBranchEn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ifCrossBranchProject")) {
      Object obj = map.get("ifCrossBranchProject");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIfCrossBranchProject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstOIDate")) {
      Object obj = map.get("firstOIDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFirstOIDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesBranchVIEWProjectId")) {
      Object obj = map.get("salesBranchVIEWProjectId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesBranchVIEWProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("executionBranchVIEWProjectId")) {
      Object obj = map.get("executionBranchVIEWProjectId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExecutionBranchVIEWProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("daprohProjectId")) {
      Object obj = map.get("daprohProjectId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDaprohProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("daprohVIEWProjectId")) {
      Object obj = map.get("daprohVIEWProjectId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDaprohVIEWProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectStatus")) {
      Object obj = map.get("projectStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentSupplierName")) {
      Object obj = map.get("agentSupplierName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAgentSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentSupplierGMDSNo")) {
      Object obj = map.get("agentSupplierGMDSNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAgentSupplierGMDSNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectEquipmentContractValue")) {
      Object obj = map.get("projectEquipmentContractValue");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectEquipmentContractValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalProjectCollectedMoney")) {
      Object obj = map.get("totalProjectCollectedMoney");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalProjectCollectedMoney((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionPercent")) {
      Object obj = map.get("collectionPercent");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionPercent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractAmountVo")) {
      Object obj = map.get("contractAmountVo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractAmountVo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAmountVo")) {
      Object obj = map.get("collectionAmountVo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionAmountVo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionPercentVo")) {
      Object obj = map.get("collectionPercentVo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionPercentVo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentFeePoNumber")) {
      Object obj = map.get("agentFeePoNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAgentFeePoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAgentFeePoAmount")) {
      Object obj = map.get("totalAgentFeePoAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAgentFeePoAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAccumulativePayableAgentFee")) {
      Object obj = map.get("totalAccumulativePayableAgentFee");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAccumulativePayableAgentFee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poStatus")) {
      Object obj = map.get("poStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAgentFeeGRAmount")) {
      Object obj = map.get("totalAgentFeeGRAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAgentFeeGRAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalVerifiedAgentFeeInvoiceAmountIR")) {
      Object obj = map.get("totalVerifiedAgentFeeInvoiceAmountIR");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalVerifiedAgentFeeInvoiceAmountIR((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentFeeLastInvoiceDate")) {
      Object obj = map.get("agentFeeLastInvoiceDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAgentFeeLastInvoiceDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentFeeInvoiceGrCheck")) {
      Object obj = map.get("agentFeeInvoiceGrCheck");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAgentFeeInvoiceGrCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("light")) {
      Object obj = map.get("light");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentFeePoAmountWithTax")) {
      Object obj = map.get("agentFeePoAmountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAgentFeePoAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentFeeTotalGRAmountWithTax")) {
      Object obj = map.get("agentFeeTotalGRAmountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAgentFeeTotalGRAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAccumulativePayableAgentFeeWithTax")) {
      Object obj = map.get("totalAccumulativePayableAgentFeeWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAccumulativePayableAgentFeeWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalVerifiedInvoiceAmountIrWithTax")) {
      Object obj = map.get("totalVerifiedInvoiceAmountIrWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalVerifiedInvoiceAmountIrWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
