package com.xforceplus.jctke.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-07-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class WbsInitFaieledHistory implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 项目定义
   */
  @TableField("projectDefinition")
  private String projectDefinition;

  /**
   * Field WBS号码
   */
  @TableField("fieldWBSNo")
  private String fieldWBSNo;

  /**
   * 地区
   */
  private String region;

  /**
   * 安装执行分公司
   */
  @TableField("installationExecutionBranch")
  private String installationExecutionBranch;

  /**
   * VIEW ID
   */
  @TableField("viewId")
  private String viewId;

  /**
   * 项目名称（英文）
   */
  @TableField("projectNameByEnglish")
  private String projectNameByEnglish;

  /**
   * MFG  WBS号码
   */
  @TableField("mfgWbsNo")
  private String mfgWbsNo;

  /**
   * 梯号
   */
  @TableField("ladderNo")
  private String ladderNo;

  /**
   * 售达方
   */
  @TableField("soldToParty")
  private String soldToParty;

  /**
   * 合同类型
   */
  @TableField("contractType")
  private String contractType;

  /**
   * 项目规模
   */
  @TableField("projectScale")
  private String projectScale;

  /**
   * 设备合同号
   */
  @TableField("equipmentContractNo")
  private String equipmentContractNo;

  /**
   * 安装合同号
   */
  @TableField("installationContractNo")
  private String installationContractNo;

  /**
   * 系统状态
   */
  @TableField("systemState")
  private String systemState;

  /**
   * 梯台状态简码
   */
  @TableField("ladderStatusCode")
  private String ladderStatusCode;

  /**
   * 梯台状态描述
   */
  @TableField("ladderStatusDesc")
  private String ladderStatusDesc;

  /**
   * 项目经理姓名
   */
  @TableField("managerName")
  private String managerName;

  /**
   * 项目经理1 8ID
   */
  @TableField("managerId")
  private String managerId;

  /**
   * 梯台设备金额（含税）
   */
  @TableField("equipmentAmountWIthTax")
  private String equipmentAmountWIthTax;

  /**
   * 梯台安装金额（含税）
   */
  @TableField("installationAmountWithTax")
  private String installationAmountWithTax;

  /**
   * 出厂地
   */
  @TableField("factoryFrom")
  private String factoryFrom;

  /**
   * 电梯梯种
   */
  @TableField("ladderSpecies")
  private String ladderSpecies;

  /**
   * 产品型号
   */
  @TableField("productModel")
  private String productModel;

  /**
   * 额定载重（公斤）
   */
  @TableField("ratedLoadOfKg")
  private String ratedLoadOfKg;

  /**
   * 额定速度（米/秒）
   */
  @TableField("ratedSpeed")
  private String ratedSpeed;

  /**
   * 行程高度(米)
   */
  @TableField("strokeHeight")
  private String strokeHeight;

  /**
   * 楼层数
   */
  private String floor;

  /**
   * 停站数
   */
  @TableField("numberOfStops")
  private String numberOfStops;

  /**
   * 井道总高（米）
   */
  @TableField("totalShaftHeight")
  private String totalShaftHeight;

  /**
   * 提升高度（米）
   */
  @TableField("liftingHeight")
  private String liftingHeight;

  /**
   * 梯级宽度（毫米）
   */
  @TableField("stepWidth")
  private String stepWidth;

  /**
   * 角度
   */
  private String angle;

  /**
   * 长度（米）
   */
  private String length;

  /**
   * 在手订单日期
   */
  @TableField("orderDate")
  private String orderDate;

  /**
   * 有效订单日期
   */
  @TableField("validOrderDate")
  private String validOrderDate;

  /**
   * PM01-工厂确认PO-实际日期
   */
  @TableField("pm01RealityDate")
  private String pm01RealityDate;

  /**
   * PM05-工厂确认排产单-计划日期
   */
  @TableField("pm05PlanDate")
  private String pm05PlanDate;

  /**
   * PM05-工厂确认排产单-实际日期
   */
  @TableField("pm05RealityDate")
  private String pm05RealityDate;

  /**
   * PM10-设备发运-计划日期
   */
  @TableField("pm10PlanDate")
  private String pm10PlanDate;

  /**
   * PM10-设备发运-实际日期
   */
  @TableField("pm10RealityDate")
  private String pm10RealityDate;

  /**
   * PM15-开工-计划日期
   */
  @TableField("pm15PlanDate")
  private String pm15PlanDate;

  /**
   * PM15-开工-实际日期
   */
  @TableField("pm15RealityDate")
  private String pm15RealityDate;

  /**
   * PM20-调试开始-计划日期
   */
  @TableField("pm20PlanDate")
  private String pm20PlanDate;

  /**
   * PM20-调试开始-实际日期
   */
  @TableField("pm20RealityDate")
  private String pm20RealityDate;

  /**
   * PM25-调试完成-计划日期
   */
  @TableField("pm25PlanDate")
  private String pm25PlanDate;

  /**
   * PM25-调试完成-实际日期
   */
  @TableField("pm25RealityDate")
  private String pm25RealityDate;

  /**
   * PM30-政府验收合格-计划日期
   */
  @TableField("pm30PlanDate")
  private String pm30PlanDate;

  /**
   * PM30-政府验收合格-实际日期
   */
  @TableField("pm30RealityDate")
  private String pm30RealityDate;

  /**
   * PM35-移交维保-计划日期
   */
  @TableField("pm35PlanDate")
  private String pm35PlanDate;

  /**
   * PM35-移交维保-实际日期
   */
  @TableField("pm35RealityDate")
  private String pm35RealityDate;

  /**
   * PM40-移交客户-计划日期
   */
  @TableField("pm40PlanDate")
  private String pm40PlanDate;

  /**
   * PM40-移交客户-实际日期
   */
  @TableField("pm405RealityDate")
  private String pm405RealityDate;

  /**
   * BI03-签约后付款-实际日期
   */
  @TableField("bi03PlanDate")
  private String bi03PlanDate;

  /**
   * BI03-签约后付款-计划日期
   */
  @TableField("bi03RealityDate")
  private String bi03RealityDate;

  /**
   * BI05-排产前付款-计划日期
   */
  @TableField("bi05PlanDate")
  private String bi05PlanDate;

  /**
   * BI05-排产前付款-实际日期
   */
  @TableField("bi05RealityDate")
  private String bi05RealityDate;

  /**
   * BI10-发货前付款-计划日期
   */
  @TableField("bi10PlanDate")
  private String bi10PlanDate;

  /**
   * BI10-发货前付款-实际日期
   */
  @TableField("bi10RealityDate")
  private String bi10RealityDate;

  /**
   * BI15-货到工地后付款-计划日期
   */
  @TableField("bi15PlanDate")
  private String bi15PlanDate;

  /**
   * BI15-货到工地后付款-实际日期
   */
  @TableField("bi15RealityDate")
  private String bi15RealityDate;

  /**
   * BI25-安装完工后付款-计划日期
   */
  @TableField("bi25PlanDate")
  private String bi25PlanDate;

  /**
   * BI25-安装完工后付款-实际日期
   */
  @TableField("bi25RealityDate")
  private String bi25RealityDate;

  /**
   * BI30-调试前付款-计划日期
   */
  @TableField("bi30PlanDate")
  private String bi30PlanDate;

  /**
   * BI30-调试前付款-实际日期
   */
  @TableField("bi30RealityDate")
  private String bi30RealityDate;

  /**
   * 主键缺失
   */
  @TableField("isPrimaryKeyAbsent")
  private String isPrimaryKeyAbsent;

  /**
   * 必填项缺失
   */
  @TableField("isRequiredAbsent")
  private String isRequiredAbsent;

  /**
   * 缺失信息描述
   */
  @TableField("absentMsg")
  private String absentMsg;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("projectDefinition", projectDefinition);
      map.put("fieldWBSNo", fieldWBSNo);
      map.put("region", region);
      map.put("installationExecutionBranch", installationExecutionBranch);
      map.put("viewId", viewId);
      map.put("projectNameByEnglish", projectNameByEnglish);
      map.put("mfgWbsNo", mfgWbsNo);
      map.put("ladderNo", ladderNo);
      map.put("soldToParty", soldToParty);
      map.put("contractType", contractType);
      map.put("projectScale", projectScale);
      map.put("equipmentContractNo", equipmentContractNo);
      map.put("installationContractNo", installationContractNo);
      map.put("systemState", systemState);
      map.put("ladderStatusCode", ladderStatusCode);
      map.put("ladderStatusDesc", ladderStatusDesc);
      map.put("managerName", managerName);
      map.put("managerId", managerId);
      map.put("equipmentAmountWIthTax", equipmentAmountWIthTax);
      map.put("installationAmountWithTax", installationAmountWithTax);
      map.put("factoryFrom", factoryFrom);
      map.put("ladderSpecies", ladderSpecies);
      map.put("productModel", productModel);
      map.put("ratedLoadOfKg", ratedLoadOfKg);
      map.put("ratedSpeed", ratedSpeed);
      map.put("strokeHeight", strokeHeight);
      map.put("floor", floor);
      map.put("numberOfStops", numberOfStops);
      map.put("totalShaftHeight", totalShaftHeight);
      map.put("liftingHeight", liftingHeight);
      map.put("stepWidth", stepWidth);
      map.put("angle", angle);
      map.put("length", length);
      map.put("orderDate", orderDate);
      map.put("validOrderDate", validOrderDate);
      map.put("pm01RealityDate", pm01RealityDate);
      map.put("pm05PlanDate", pm05PlanDate);
      map.put("pm05RealityDate", pm05RealityDate);
      map.put("pm10PlanDate", pm10PlanDate);
      map.put("pm10RealityDate", pm10RealityDate);
      map.put("pm15PlanDate", pm15PlanDate);
      map.put("pm15RealityDate", pm15RealityDate);
      map.put("pm20PlanDate", pm20PlanDate);
      map.put("pm20RealityDate", pm20RealityDate);
      map.put("pm25PlanDate", pm25PlanDate);
      map.put("pm25RealityDate", pm25RealityDate);
      map.put("pm30PlanDate", pm30PlanDate);
      map.put("pm30RealityDate", pm30RealityDate);
      map.put("pm35PlanDate", pm35PlanDate);
      map.put("pm35RealityDate", pm35RealityDate);
      map.put("pm40PlanDate", pm40PlanDate);
      map.put("pm405RealityDate", pm405RealityDate);
      map.put("bi03PlanDate", bi03PlanDate);
      map.put("bi03RealityDate", bi03RealityDate);
      map.put("bi05PlanDate", bi05PlanDate);
      map.put("bi05RealityDate", bi05RealityDate);
      map.put("bi10PlanDate", bi10PlanDate);
      map.put("bi10RealityDate", bi10RealityDate);
      map.put("bi15PlanDate", bi15PlanDate);
      map.put("bi15RealityDate", bi15RealityDate);
      map.put("bi25PlanDate", bi25PlanDate);
      map.put("bi25RealityDate", bi25RealityDate);
      map.put("bi30PlanDate", bi30PlanDate);
      map.put("bi30RealityDate", bi30RealityDate);
      map.put("isPrimaryKeyAbsent", isPrimaryKeyAbsent);
      map.put("isRequiredAbsent", isRequiredAbsent);
      map.put("absentMsg", absentMsg);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static WbsInitFaieledHistory fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    WbsInitFaieledHistory entity = new WbsInitFaieledHistory();
    if(map.containsKey("projectDefinition")) {
      Object obj = map.get("projectDefinition");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectDefinition((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fieldWBSNo")) {
      Object obj = map.get("fieldWBSNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFieldWBSNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("region")) {
      Object obj = map.get("region");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("installationExecutionBranch")) {
      Object obj = map.get("installationExecutionBranch");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInstallationExecutionBranch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("viewId")) {
      Object obj = map.get("viewId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setViewId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNameByEnglish")) {
      Object obj = map.get("projectNameByEnglish");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectNameByEnglish((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mfgWbsNo")) {
      Object obj = map.get("mfgWbsNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMfgWbsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderNo")) {
      Object obj = map.get("ladderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("soldToParty")) {
      Object obj = map.get("soldToParty");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSoldToParty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractType")) {
      Object obj = map.get("contractType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectScale")) {
      Object obj = map.get("projectScale");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectScale((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("equipmentContractNo")) {
      Object obj = map.get("equipmentContractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEquipmentContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("installationContractNo")) {
      Object obj = map.get("installationContractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInstallationContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemState")) {
      Object obj = map.get("systemState");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemState((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderStatusCode")) {
      Object obj = map.get("ladderStatusCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderStatusCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderStatusDesc")) {
      Object obj = map.get("ladderStatusDesc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderStatusDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("managerName")) {
      Object obj = map.get("managerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setManagerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("managerId")) {
      Object obj = map.get("managerId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setManagerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("equipmentAmountWIthTax")) {
      Object obj = map.get("equipmentAmountWIthTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEquipmentAmountWIthTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("installationAmountWithTax")) {
      Object obj = map.get("installationAmountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInstallationAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("factoryFrom")) {
      Object obj = map.get("factoryFrom");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFactoryFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ladderSpecies")) {
      Object obj = map.get("ladderSpecies");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLadderSpecies((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productModel")) {
      Object obj = map.get("productModel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductModel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ratedLoadOfKg")) {
      Object obj = map.get("ratedLoadOfKg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRatedLoadOfKg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ratedSpeed")) {
      Object obj = map.get("ratedSpeed");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRatedSpeed((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("strokeHeight")) {
      Object obj = map.get("strokeHeight");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStrokeHeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("floor")) {
      Object obj = map.get("floor");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFloor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberOfStops")) {
      Object obj = map.get("numberOfStops");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNumberOfStops((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalShaftHeight")) {
      Object obj = map.get("totalShaftHeight");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalShaftHeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("liftingHeight")) {
      Object obj = map.get("liftingHeight");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLiftingHeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stepWidth")) {
      Object obj = map.get("stepWidth");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStepWidth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("angle")) {
      Object obj = map.get("angle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAngle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("length")) {
      Object obj = map.get("length");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLength((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderDate")) {
      Object obj = map.get("orderDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("validOrderDate")) {
      Object obj = map.get("validOrderDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setValidOrderDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pm01RealityDate")) {
      Object obj = map.get("pm01RealityDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPm01RealityDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pm05PlanDate")) {
      Object obj = map.get("pm05PlanDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPm05PlanDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pm05RealityDate")) {
      Object obj = map.get("pm05RealityDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPm05RealityDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pm10PlanDate")) {
      Object obj = map.get("pm10PlanDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPm10PlanDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pm10RealityDate")) {
      Object obj = map.get("pm10RealityDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPm10RealityDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pm15PlanDate")) {
      Object obj = map.get("pm15PlanDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPm15PlanDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pm15RealityDate")) {
      Object obj = map.get("pm15RealityDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPm15RealityDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pm20PlanDate")) {
      Object obj = map.get("pm20PlanDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPm20PlanDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pm20RealityDate")) {
      Object obj = map.get("pm20RealityDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPm20RealityDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pm25PlanDate")) {
      Object obj = map.get("pm25PlanDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPm25PlanDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pm25RealityDate")) {
      Object obj = map.get("pm25RealityDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPm25RealityDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pm30PlanDate")) {
      Object obj = map.get("pm30PlanDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPm30PlanDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pm30RealityDate")) {
      Object obj = map.get("pm30RealityDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPm30RealityDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pm35PlanDate")) {
      Object obj = map.get("pm35PlanDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPm35PlanDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pm35RealityDate")) {
      Object obj = map.get("pm35RealityDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPm35RealityDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pm40PlanDate")) {
      Object obj = map.get("pm40PlanDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPm40PlanDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pm405RealityDate")) {
      Object obj = map.get("pm405RealityDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPm405RealityDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bi03PlanDate")) {
      Object obj = map.get("bi03PlanDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBi03PlanDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bi03RealityDate")) {
      Object obj = map.get("bi03RealityDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBi03RealityDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bi05PlanDate")) {
      Object obj = map.get("bi05PlanDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBi05PlanDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bi05RealityDate")) {
      Object obj = map.get("bi05RealityDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBi05RealityDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bi10PlanDate")) {
      Object obj = map.get("bi10PlanDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBi10PlanDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bi10RealityDate")) {
      Object obj = map.get("bi10RealityDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBi10RealityDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bi15PlanDate")) {
      Object obj = map.get("bi15PlanDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBi15PlanDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bi15RealityDate")) {
      Object obj = map.get("bi15RealityDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBi15RealityDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bi25PlanDate")) {
      Object obj = map.get("bi25PlanDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBi25PlanDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bi25RealityDate")) {
      Object obj = map.get("bi25RealityDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBi25RealityDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bi30PlanDate")) {
      Object obj = map.get("bi30PlanDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBi30PlanDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bi30RealityDate")) {
      Object obj = map.get("bi30RealityDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBi30RealityDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isPrimaryKeyAbsent")) {
      Object obj = map.get("isPrimaryKeyAbsent");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsPrimaryKeyAbsent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isRequiredAbsent")) {
      Object obj = map.get("isRequiredAbsent");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsRequiredAbsent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAbsentMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
