package com.xforceplus.jctke.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-07-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaseInitFailedHistory implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 采购单号
   */
  @TableField("poNumber")
  private String poNumber;

  /**
   * 货币
   */
  private String currency;

  /**
   * 发布状态Raw
   */
  @TableField("postStatusRaw")
  private String postStatusRaw;

  /**
   * 总帐科目
   */
  @TableField("generalLedgerAccount")
  private String generalLedgerAccount;

  /**
   * 成本中心
   */
  @TableField("costCenter")
  private String costCenter;

  /**
   * 主键缺失
   */
  @TableField("isPrimaryKeyAbsent")
  private Boolean isPrimaryKeyAbsent;

  /**
   * 必填项缺失
   */
  @TableField("isRequiredAbsent")
  private Boolean isRequiredAbsent;

  /**
   * 缺失信息描述
   */
  @TableField("absentMsg")
  private String absentMsg;

  /**
   * 销方编号
   */
  @TableField("sellerNo")
  private String sellerNo;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 执行分公司
   */
  @TableField("buyerName")
  private String buyerName;

  /**
   * 业务类型
   */
  @TableField("businessType")
  private String businessType;

  /**
   * 已付款金额
   */
  @TableField("payedAmount")
  private BigDecimal payedAmount;

  /**
   * 已开票金额
   */
  @TableField("invoicedAmount")
  private BigDecimal invoicedAmount;

  /**
   * 待开票金额
   */
  @TableField("waitForInvoiceAmount")
  private BigDecimal waitForInvoiceAmount;

  /**
   * 已收货金额
   */
  @TableField("deliveriedAmount")
  private BigDecimal deliveriedAmount;

  /**
   * 预付金额
   */
  @TableField("prepayAmount")
  private BigDecimal prepayAmount;

  /**
   * 未付金额
   */
  @TableField("unpayedAmount")
  private BigDecimal unpayedAmount;

  /**
   * 执行分公司Id
   */
  @TableField("buyerID")
  private String buyerID;

  /**
   * 失败原因
   */
  @TableField("failureReason")
  private String failureReason;

  /**
   * 采购组
   */
  @TableField("purchasingTeam")
  private String purchasingTeam;

  /**
   * 采购组织
   */
  @TableField("purchasingOrg")
  private String purchasingOrg;

  /**
   * 已预付待核销金额
   */
  @TableField("prepaidAmount")
  private BigDecimal prepaidAmount;

  /**
   * 发票分公司Id
   */
  @TableField("buyerInvoiceID")
  private String buyerInvoiceID;

  /**
   * 发票分公司
   */
  @TableField("buyerInvoiceTitle")
  private String buyerInvoiceTitle;

  /**
   * 订单总价值
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 协同关系
   */
  @TableField("isCoord")
  private String isCoord;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 购方编号
   */
  @TableField("purchaserNo")
  private String purchaserNo;

  /**
   * 物料编号
   */
  @TableField("materialServices")
  private String materialServices;

  /**
   * 订单单位
   */
  @TableField("quantityUnit")
  private String quantityUnit;

  /**
   * 含税金额Raw
   */
  @TableField("amountWithTaxRaw")
  private String amountWithTaxRaw;

  /**
   * WBS
   */
  private String wbs;

  /**
   * 物料名称
   */
  @TableField("materialServicesName")
  private String materialServicesName;

  /**
   * 合同号
   */
  @TableField("contractID")
  private String contractID;

  /**
   * 项目名称
   */
  @TableField("projectName")
  private String projectName;

  /**
   * 税码
   */
  @TableField("vatCode")
  private String vatCode;

  /**
   * 物料组
   */
  @TableField("materialServicesTeam")
  private String materialServicesTeam;

  /**
   * 利润中心
   */
  @TableField("profitsCenter")
  private String profitsCenter;

  /**
   * View Id
   */
  @TableField("viewId")
  private String viewId;

  /**
   * 订单状态
   */
  @TableField("orderStatus")
  private String orderStatus;

  /**
   * 订单类型
   */
  @TableField("orderType")
  private String orderType;

  /**
   * 行号
   */
  private Long item;

  /**
   * 删除标记
   */
  @TableField("isDelete")
  private Boolean isDelete;

  /**
   * 数量
   */
  private BigDecimal quantity;

  /**
   * 发布状态
   */
  @TableField("postStatus")
  private String postStatus;

  /**
   * 净价
   */
  @TableField("unitPrice")
  private BigDecimal unitPrice;

  /**
   * 供应商/供应工厂
   */
  private String seller;

  /**
   * 删除标记Raw
   */
  @TableField("isDeleteRaw")
  private String isDeleteRaw;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 销方银行账号
   */
  @TableField("sellerBankNo")
  private String sellerBankNo;

  /**
   * 销方银行名称
   */
  @TableField("sellerBankName")
  private String sellerBankName;

  /**
   * 销方地址
   */
  @TableField("sellerAddress")
  private String sellerAddress;

  /**
   * 销方联系电话
   */
  @TableField("sellerTelephone")
  private String sellerTelephone;

  /**
   * 购方银行账号
   */
  @TableField("purchaseBankNo")
  private String purchaseBankNo;

  /**
   * 购方银行名称
   */
  @TableField("purchaseBankName")
  private String purchaseBankName;

  /**
   * 购方地址
   */
  @TableField("purchaseAddress")
  private String purchaseAddress;

  /**
   * 购方联系电话
   */
  @TableField("purchaseTelephone")
  private String purchaseTelephone;

  /**
   * wbs切割值
   */
  @TableField("wbsSub")
  private String wbsSub;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("poNumber", poNumber);
      map.put("currency", currency);
      map.put("postStatusRaw", postStatusRaw);
      map.put("generalLedgerAccount", generalLedgerAccount);
      map.put("costCenter", costCenter);
      map.put("isPrimaryKeyAbsent", isPrimaryKeyAbsent);
      map.put("isRequiredAbsent", isRequiredAbsent);
      map.put("absentMsg", absentMsg);
      map.put("sellerNo", sellerNo);
      map.put("sellerName", sellerName);
      map.put("buyerName", buyerName);
      map.put("businessType", businessType);
      map.put("payedAmount", payedAmount);
      map.put("invoicedAmount", invoicedAmount);
      map.put("waitForInvoiceAmount", waitForInvoiceAmount);
      map.put("deliveriedAmount", deliveriedAmount);
      map.put("prepayAmount", prepayAmount);
      map.put("unpayedAmount", unpayedAmount);
      map.put("buyerID", buyerID);
      map.put("failureReason", failureReason);
      map.put("purchasingTeam", purchasingTeam);
      map.put("purchasingOrg", purchasingOrg);
      map.put("prepaidAmount", prepaidAmount);
      map.put("buyerInvoiceID", buyerInvoiceID);
      map.put("buyerInvoiceTitle", buyerInvoiceTitle);
      map.put("amountWithTax", amountWithTax);
      map.put("isCoord", isCoord);
      map.put("invoiceType", invoiceType);
      map.put("purchaserName", purchaserName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("purchaserNo", purchaserNo);
      map.put("materialServices", materialServices);
      map.put("quantityUnit", quantityUnit);
      map.put("amountWithTaxRaw", amountWithTaxRaw);
      map.put("wbs", wbs);
      map.put("materialServicesName", materialServicesName);
      map.put("contractID", contractID);
      map.put("projectName", projectName);
      map.put("vatCode", vatCode);
      map.put("materialServicesTeam", materialServicesTeam);
      map.put("profitsCenter", profitsCenter);
      map.put("viewId", viewId);
      map.put("orderStatus", orderStatus);
      map.put("orderType", orderType);
      map.put("item", item);
      map.put("isDelete", isDelete);
      map.put("quantity", quantity);
      map.put("postStatus", postStatus);
      map.put("unitPrice", unitPrice);
      map.put("seller", seller);
      map.put("isDeleteRaw", isDeleteRaw);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("sellerBankNo", sellerBankNo);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTelephone", sellerTelephone);
      map.put("purchaseBankNo", purchaseBankNo);
      map.put("purchaseBankName", purchaseBankName);
      map.put("purchaseAddress", purchaseAddress);
      map.put("purchaseTelephone", purchaseTelephone);
      map.put("wbsSub", wbsSub);
      return map;
  }

  public static PurchaseInitFailedHistory fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaseInitFailedHistory entity = new PurchaseInitFailedHistory();
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postStatusRaw")) {
      Object obj = map.get("postStatusRaw");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPostStatusRaw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generalLedgerAccount")) {
      Object obj = map.get("generalLedgerAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGeneralLedgerAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isPrimaryKeyAbsent")) {
      Object obj = map.get("isPrimaryKeyAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsPrimaryKeyAbsent((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsPrimaryKeyAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("isRequiredAbsent")) {
      Object obj = map.get("isRequiredAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsRequiredAbsent((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsRequiredAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAbsentMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payedAmount")) {
      Object obj = map.get("payedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPayedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoicedAmount")) {
      Object obj = map.get("invoicedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoicedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoicedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoicedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoicedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoicedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("waitForInvoiceAmount")) {
      Object obj = map.get("waitForInvoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setWaitForInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setWaitForInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setWaitForInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setWaitForInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWaitForInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deliveriedAmount")) {
      Object obj = map.get("deliveriedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDeliveriedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDeliveriedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDeliveriedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDeliveriedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeliveriedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prepayAmount")) {
      Object obj = map.get("prepayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrepayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrepayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrepayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPrepayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrepayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unpayedAmount")) {
      Object obj = map.get("unpayedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnpayedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnpayedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnpayedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnpayedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnpayedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyerID")) {
      Object obj = map.get("buyerID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("failureReason")) {
      Object obj = map.get("failureReason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFailureReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingTeam")) {
      Object obj = map.get("purchasingTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchasingTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingOrg")) {
      Object obj = map.get("purchasingOrg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchasingOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaidAmount")) {
      Object obj = map.get("prepaidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrepaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrepaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrepaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPrepaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrepaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceID")) {
      Object obj = map.get("buyerInvoiceID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerInvoiceID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerInvoiceTitle")) {
      Object obj = map.get("buyerInvoiceTitle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerInvoiceTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("isCoord")) {
      Object obj = map.get("isCoord");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsCoord((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServices")) {
      Object obj = map.get("materialServices");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServices((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTaxRaw")) {
      Object obj = map.get("amountWithTaxRaw");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithTaxRaw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWbs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesName")) {
      Object obj = map.get("materialServicesName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServicesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractID")) {
      Object obj = map.get("contractID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatCode")) {
      Object obj = map.get("vatCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVatCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesTeam")) {
      Object obj = map.get("materialServicesTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialServicesTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profitsCenter")) {
      Object obj = map.get("profitsCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProfitsCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("viewId")) {
      Object obj = map.get("viewId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setViewId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setItem((Long)obj);
        } else if(obj instanceof String) {
          entity.setItem(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setItem(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("isDelete")) {
      Object obj = map.get("isDelete");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsDelete((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsDelete(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("postStatus")) {
      Object obj = map.get("postStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPostStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("seller")) {
      Object obj = map.get("seller");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSeller((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDeleteRaw")) {
      Object obj = map.get("isDeleteRaw");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsDeleteRaw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankNo")) {
      Object obj = map.get("sellerBankNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTelephone")) {
      Object obj = map.get("sellerTelephone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTelephone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBankNo")) {
      Object obj = map.get("purchaseBankNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBankName")) {
      Object obj = map.get("purchaseBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseAddress")) {
      Object obj = map.get("purchaseAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseTelephone")) {
      Object obj = map.get("purchaseTelephone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseTelephone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wbsSub")) {
      Object obj = map.get("wbsSub");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWbsSub((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
