package com.xforceplus.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票操作类型
 * </p>
 *
 * @author ultraman
 * @since 2022-08-18
 */
public enum InvoiceOperation {

    BACK("back", "退回"),
    SEND("send", "寄送"),
    SIGN("sign", "签收");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceOperation(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceOperation fromCode(String code){
        switch(code) {
            case "back":
                return BACK;
            case "send":
                return SEND;
            case "sign":
                return SIGN;
            default:
                return null;
        }
    }
}
