package com.xforceplus.jctke.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-09-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AgentPaymentTermInit implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 项目编号
   */
  @TableField("projectId")
  private String projectId;

  /**
   * 代理商ID
   */
  @TableField("agentId")
  private String agentId;

  /**
   * 行号
   */
  @TableField("contractPaymentTermKey")
  private String contractPaymentTermKey;

  /**
   * 合同款比例
   */
  @TableField("contractPaymentTerm")
  private String contractPaymentTerm;

  /**
   * 支付比例
   */
  @TableField("paymentTerm")
  private String paymentTerm;

  /**
   * 支付比例说明(中文)
   */
  @TableField("paymentTermDesLocal")
  private String paymentTermDesLocal;

  /**
   * 支付比例说明（英文）
   */
  @TableField("paymentTermDesEn")
  private String paymentTermDesEn;

  /**
   * 支付额
   */
  private String value;

  /**
   * 状态
   */
  private String status;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 主键缺失
   */
  @TableField("isPrimaryKeyAbsent")
  private Boolean isPrimaryKeyAbsent;

  /**
   * 必填项缺失
   */
  @TableField("isRequiredAbsent")
  private Boolean isRequiredAbsent;

  /**
   * 缺失信息描述
   */
  @TableField("absentMsg")
  private String absentMsg;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("projectId", projectId);
      map.put("agentId", agentId);
      map.put("contractPaymentTermKey", contractPaymentTermKey);
      map.put("contractPaymentTerm", contractPaymentTerm);
      map.put("paymentTerm", paymentTerm);
      map.put("paymentTermDesLocal", paymentTermDesLocal);
      map.put("paymentTermDesEn", paymentTermDesEn);
      map.put("value", value);
      map.put("status", status);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("isPrimaryKeyAbsent", isPrimaryKeyAbsent);
      map.put("isRequiredAbsent", isRequiredAbsent);
      map.put("absentMsg", absentMsg);
      return map;
  }

  public static AgentPaymentTermInit fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    AgentPaymentTermInit entity = new AgentPaymentTermInit();
    if(map.containsKey("projectId")) {
      Object obj = map.get("projectId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentId")) {
      Object obj = map.get("agentId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAgentId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractPaymentTermKey")) {
      Object obj = map.get("contractPaymentTermKey");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractPaymentTermKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractPaymentTerm")) {
      Object obj = map.get("contractPaymentTerm");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractPaymentTerm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentTerm")) {
      Object obj = map.get("paymentTerm");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentTerm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentTermDesLocal")) {
      Object obj = map.get("paymentTermDesLocal");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentTermDesLocal((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentTermDesEn")) {
      Object obj = map.get("paymentTermDesEn");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentTermDesEn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("value")) {
      Object obj = map.get("value");
      if(obj != null) {
        if(obj instanceof String){
          entity.setValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isPrimaryKeyAbsent")) {
      Object obj = map.get("isPrimaryKeyAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsPrimaryKeyAbsent((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsPrimaryKeyAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("isRequiredAbsent")) {
      Object obj = map.get("isRequiredAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsRequiredAbsent((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsRequiredAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAbsentMsg((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
