package com.xforceplus.jctke.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-11-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceNoticeBillRelation implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 配单含税金额
   */
  @TableField("distributeOrderAmount")
  private BigDecimal distributeOrderAmount;

  /**
   * 开票通知单号
   */
  @TableField("invoiceNoticeNo")
  private String invoiceNoticeNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 发票id
   */
  @TableField("invoiceId")
  private Long invoiceId;

  /**
   * 开票通知单id
   */
  @TableField("invoiceNoticeBillId")
  private Long invoiceNoticeBillId;

  /**
   * 发票状态
   */
  @TableField("invoiceRegisterStatus")
  private String invoiceRegisterStatus;

  /**
   * 采购单号
   */
  @TableField("purchaseOrderNo")
  private String purchaseOrderNo;

  /**
   * 原发票号码
   */
  @TableField("originInvoiceNo")
  private String originInvoiceNo;

  /**
   * 原发票代码
   */
  @TableField("originInvoiceCode")
  private String originInvoiceCode;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private String amountWithTax;

  /**
   * 配单不含税金额
   */
  @TableField("matchedAmountWithoutTax")
  private BigDecimal matchedAmountWithoutTax;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("distributeOrderAmount", distributeOrderAmount);
      map.put("invoiceNoticeNo", invoiceNoticeNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("invoiceId", invoiceId);
      map.put("invoiceNoticeBillId", invoiceNoticeBillId);
      map.put("invoiceRegisterStatus", invoiceRegisterStatus);
      map.put("purchaseOrderNo", purchaseOrderNo);
      map.put("originInvoiceNo", originInvoiceNo);
      map.put("originInvoiceCode", originInvoiceCode);
      map.put("amountWithTax", amountWithTax);
      map.put("matchedAmountWithoutTax", matchedAmountWithoutTax);
      return map;
  }

  public static InvoiceNoticeBillRelation fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceNoticeBillRelation entity = new InvoiceNoticeBillRelation();
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distributeOrderAmount")) {
      Object obj = map.get("distributeOrderAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDistributeOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDistributeOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDistributeOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDistributeOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDistributeOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeNo")) {
      Object obj = map.get("invoiceNoticeNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNoticeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceId((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNoticeBillId")) {
      Object obj = map.get("invoiceNoticeBillId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceNoticeBillId((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceNoticeBillId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceNoticeBillId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceRegisterStatus")) {
      Object obj = map.get("invoiceRegisterStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceRegisterStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseOrderNo")) {
      Object obj = map.get("purchaseOrderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchedAmountWithoutTax")) {
      Object obj = map.get("matchedAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMatchedAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMatchedAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMatchedAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setMatchedAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMatchedAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distributeOrderAmount")) {
      Object obj = map.get("distributeOrderAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDistributeOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDistributeOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDistributeOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setDistributeOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDistributeOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNoticeNo")) {
      Object obj = map.get("invoiceNoticeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNoticeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceId((Long)obj);
        } else if(obj instanceof String) {
          this.setInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNoticeBillId")) {
      Object obj = map.get("invoiceNoticeBillId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceNoticeBillId((Long)obj);
        } else if(obj instanceof String) {
          this.setInvoiceNoticeBillId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceNoticeBillId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceRegisterStatus")) {
      Object obj = map.get("invoiceRegisterStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceRegisterStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseOrderNo")) {
      Object obj = map.get("purchaseOrderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("matchedAmountWithoutTax")) {
      Object obj = map.get("matchedAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setMatchedAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setMatchedAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setMatchedAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setMatchedAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setMatchedAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
  }
}
