package com.xforceplus.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 备用金类型
 * </p>
 *
 * @author ultraman
 * @since 2022-12-25
 */
public enum PettyCashType {

    _1("1", "差旅费及小额交际"),
    _2("2", "行政费用"),
    _3("3", "营业税及其它税金附加费"),
    _4("4", "验收费"),
    _5("5", "诉讼费");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PettyCashType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PettyCashType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
