package com.xforceplus.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 验真状态
 * </p>
 *
 * @author ultraman
 * @since 2023-02-18
 */
public enum TrueStatus {

    _0("0", "未购买验真"),
    _2("2", "验真中"),
    _3("3", "国税暂无此票"),
    _4("4", "验真成功");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TrueStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TrueStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
