package com.xforceplus.jctke.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-02-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CostCenter implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 利润中心
   */
  @TableField("profitCenter")
  private String profitCenter;

  /**
   * Performance Branch
   */
  @TableField("performanceBranch")
  private String performanceBranch;

  /**
   * Tax Branch
   */
  @TableField("taxBranch")
  private String taxBranch;

  /**
   * 区域
   */
  private String region;

  /**
   * 城市
   */
  private String city;

  /**
   * 成本中心
   */
  @TableField("costCenter")
  private String costCenter;

  /**
   * CTR Short Text
   */
  @TableField("ctrShortText")
  private String ctrShortText;

  /**
   * CTR Long Text
   */
  @TableField("ctrLongText")
  private String ctrLongText;

  /**
   * 中文短文本
   */
  @TableField("chineseShortText")
  private String chineseShortText;

  /**
   * 中文长文本
   */
  @TableField("chineseLongText")
  private String chineseLongText;

  /**
   * 拓展字段1
   */
  private String ext1;

  /**
   * 拓展字段2
   */
  private String ext2;

  /**
   * 拓展字段3
   */
  private String ext3;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 行号
   */
  @TableField("lineId")
  private Long lineId;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("profitCenter", profitCenter);
      map.put("performanceBranch", performanceBranch);
      map.put("taxBranch", taxBranch);
      map.put("region", region);
      map.put("city", city);
      map.put("costCenter", costCenter);
      map.put("ctrShortText", ctrShortText);
      map.put("ctrLongText", ctrLongText);
      map.put("chineseShortText", chineseShortText);
      map.put("chineseLongText", chineseLongText);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("lineId", lineId);
      return map;
  }

  public static CostCenter fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    CostCenter entity = new CostCenter();
    if(map.containsKey("profitCenter")) {
      Object obj = map.get("profitCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProfitCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("performanceBranch")) {
      Object obj = map.get("performanceBranch");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPerformanceBranch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxBranch")) {
      Object obj = map.get("taxBranch");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxBranch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("region")) {
      Object obj = map.get("region");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ctrShortText")) {
      Object obj = map.get("ctrShortText");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCtrShortText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ctrLongText")) {
      Object obj = map.get("ctrLongText");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCtrLongText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chineseShortText")) {
      Object obj = map.get("chineseShortText");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChineseShortText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chineseLongText")) {
      Object obj = map.get("chineseLongText");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChineseLongText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lineId")) {
      Object obj = map.get("lineId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLineId((Long)obj);
        } else if(obj instanceof String) {
          entity.setLineId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLineId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("profitCenter")) {
      Object obj = map.get("profitCenter");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProfitCenter((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("performanceBranch")) {
      Object obj = map.get("performanceBranch");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPerformanceBranch((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxBranch")) {
      Object obj = map.get("taxBranch");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxBranch((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("region")) {
      Object obj = map.get("region");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCostCenter((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ctrShortText")) {
      Object obj = map.get("ctrShortText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCtrShortText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ctrLongText")) {
      Object obj = map.get("ctrLongText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCtrLongText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chineseShortText")) {
      Object obj = map.get("chineseShortText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChineseShortText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chineseLongText")) {
      Object obj = map.get("chineseLongText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChineseLongText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lineId")) {
      Object obj = map.get("lineId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLineId((Long)obj);
        } else if(obj instanceof String) {
          this.setLineId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setLineId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
  }
}
