package com.xforceplus.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 编码类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-09
 */
public enum CodeType {

    L_1("L_1", "虚拟采购单号");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CodeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CodeType fromCode(String code){
        switch(code) {
            case "L_1":
                return L_1;
            default:
                return null;
        }
    }
}
