package com.xforceplus.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 待办状态
 * </p>
 *
 * @author ultraman
 * @since 2023-04-17
 */
public enum ProduceStatus {

    _10("10", "待处理"),
    _200("200", "处理中"),
    _300("300", "处理成功"),
    __100("-100", "处理失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProduceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProduceStatus fromCode(String code){
        switch(code) {
            case "10":
                return _10;
            case "200":
                return _200;
            case "300":
                return _300;
            case "-100":
                return __100;
            default:
                return null;
        }
    }
}
