package com.xforceplus.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 付款单操作类型
 * </p>
 *
 * @author ultraman
 * @since 2023-04-25
 */
public enum ApprovalStatus {

    _0("0", "驳回"),
    _1("1", "通过"),
    _2("2", "提交"),
    _3("3", "撤回"),
    _4("4", "FBL1N"),
    _5("5", "FB08"),
    _6("6", "MR8M"),
    _7("7", "F44"),
    _8("8", "F47"),
    _9("9", "F51"),
    _10("10", "FBRA"),
    _11("11", "MIRO"),
    _12("12", "配单"),
    _13("13", "删除"),
    _14("14", "自动收货"),
    _15("15", "终止"),
    _16("16", "修改预付款");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ApprovalStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApprovalStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            default:
                return null;
        }
    }
}
