package com.xforceplus.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 快照格式
 * </p>
 *
 * @author ultraman
 * @since 2023-04-25
 */
public enum SnaphostFormat {

    _1("1", "直接存取"),
    _2("2", "文件存取"),
    DIRECT("direct", "直接存取"),
    FILE("file", "文件存取");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SnaphostFormat(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SnaphostFormat fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "direct":
                return DIRECT;
            case "file":
                return FILE;
            default:
                return null;
        }
    }
}
