package com.xforceplus.jctke.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-04-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ApprovalTemplate implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 预付款类型
   */
  @TableField("prepaymentType")
  private String prepaymentType;

  /**
   * 保证金类型
   */
  @TableField("bondType")
  private String bondType;

  /**
   * 角色序号
   */
  @TableField("roleSerialNumber")
  private Long roleSerialNumber;

  /**
   * 角色编码
   */
  @TableField("roleType")
  private String roleType;

  /**
   * 角色英文描述
   */
  @TableField("roleEnglishDescription")
  private String roleEnglishDescription;

  /**
   * 有效期左边界值
   */
  @TableField("validityPeriodLeftBorderValue")
  private Long validityPeriodLeftBorderValue;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 有效期左边界符号
   */
  @TableField("validityPeriodLeftBorderSymbol")
  private String validityPeriodLeftBorderSymbol;

  /**
   * 有效期右边界值
   */
  @TableField("validityPeriodRightBorderValue")
  private Long validityPeriodRightBorderValue;

  /**
   * 有效期右边界符号
   */
  @TableField("validityPeriodRightBorderSymbol")
  private String validityPeriodRightBorderSymbol;

  /**
   * 金额比例左边界值
   */
  @TableField("amountRatioLeftBorderValue")
  private BigDecimal amountRatioLeftBorderValue;

  /**
   * 金额比例左边界符号
   */
  @TableField("amountRatioLeftBorderSymbol")
  private String amountRatioLeftBorderSymbol;

  /**
   * 金额比例右边界值
   */
  @TableField("amountRatioRightBorderValue")
  private BigDecimal amountRatioRightBorderValue;

  /**
   * 金额比例右边界符号
   */
  @TableField("amountRatioRightBorderSymbol")
  private String amountRatioRightBorderSymbol;

  /**
   * 金额左边界值
   */
  @TableField("amountLeftBorderValue")
  private BigDecimal amountLeftBorderValue;

  /**
   * 金额左边界符号
   */
  @TableField("amountLeftBorderSymbol")
  private String amountLeftBorderSymbol;

  /**
   * 金额右边界值
   */
  @TableField("amountRightBorderValue")
  private BigDecimal amountRightBorderValue;

  /**
   * 金额右边界符号
   */
  @TableField("amountRightBorderSymbol")
  private String amountRightBorderSymbol;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("prepaymentType", prepaymentType);
      map.put("bondType", bondType);
      map.put("roleSerialNumber", roleSerialNumber);
      map.put("roleType", roleType);
      map.put("roleEnglishDescription", roleEnglishDescription);
      map.put("validityPeriodLeftBorderValue", validityPeriodLeftBorderValue);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("validityPeriodLeftBorderSymbol", validityPeriodLeftBorderSymbol);
      map.put("validityPeriodRightBorderValue", validityPeriodRightBorderValue);
      map.put("validityPeriodRightBorderSymbol", validityPeriodRightBorderSymbol);
      map.put("amountRatioLeftBorderValue", amountRatioLeftBorderValue);
      map.put("amountRatioLeftBorderSymbol", amountRatioLeftBorderSymbol);
      map.put("amountRatioRightBorderValue", amountRatioRightBorderValue);
      map.put("amountRatioRightBorderSymbol", amountRatioRightBorderSymbol);
      map.put("amountLeftBorderValue", amountLeftBorderValue);
      map.put("amountLeftBorderSymbol", amountLeftBorderSymbol);
      map.put("amountRightBorderValue", amountRightBorderValue);
      map.put("amountRightBorderSymbol", amountRightBorderSymbol);
      return map;
  }

  public static ApprovalTemplate fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ApprovalTemplate entity = new ApprovalTemplate();
    if(map.containsKey("prepaymentType")) {
      Object obj = map.get("prepaymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bondType")) {
      Object obj = map.get("bondType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBondType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("roleSerialNumber")) {
      Object obj = map.get("roleSerialNumber");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRoleSerialNumber((Long)obj);
        } else if(obj instanceof String) {
          entity.setRoleSerialNumber(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRoleSerialNumber(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("roleType")) {
      Object obj = map.get("roleType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRoleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("roleEnglishDescription")) {
      Object obj = map.get("roleEnglishDescription");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRoleEnglishDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("validityPeriodLeftBorderValue")) {
      Object obj = map.get("validityPeriodLeftBorderValue");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setValidityPeriodLeftBorderValue((Long)obj);
        } else if(obj instanceof String) {
          entity.setValidityPeriodLeftBorderValue(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setValidityPeriodLeftBorderValue(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("validityPeriodLeftBorderSymbol")) {
      Object obj = map.get("validityPeriodLeftBorderSymbol");
      if(obj != null) {
        if(obj instanceof String){
          entity.setValidityPeriodLeftBorderSymbol((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("validityPeriodRightBorderValue")) {
      Object obj = map.get("validityPeriodRightBorderValue");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setValidityPeriodRightBorderValue((Long)obj);
        } else if(obj instanceof String) {
          entity.setValidityPeriodRightBorderValue(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setValidityPeriodRightBorderValue(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("validityPeriodRightBorderSymbol")) {
      Object obj = map.get("validityPeriodRightBorderSymbol");
      if(obj != null) {
        if(obj instanceof String){
          entity.setValidityPeriodRightBorderSymbol((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountRatioLeftBorderValue")) {
      Object obj = map.get("amountRatioLeftBorderValue");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountRatioLeftBorderValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountRatioLeftBorderValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountRatioLeftBorderValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountRatioLeftBorderValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountRatioLeftBorderValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountRatioLeftBorderSymbol")) {
      Object obj = map.get("amountRatioLeftBorderSymbol");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountRatioLeftBorderSymbol((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountRatioRightBorderValue")) {
      Object obj = map.get("amountRatioRightBorderValue");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountRatioRightBorderValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountRatioRightBorderValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountRatioRightBorderValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountRatioRightBorderValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountRatioRightBorderValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountRatioRightBorderSymbol")) {
      Object obj = map.get("amountRatioRightBorderSymbol");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountRatioRightBorderSymbol((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountLeftBorderValue")) {
      Object obj = map.get("amountLeftBorderValue");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountLeftBorderValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountLeftBorderValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountLeftBorderValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountLeftBorderValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountLeftBorderValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountLeftBorderSymbol")) {
      Object obj = map.get("amountLeftBorderSymbol");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountLeftBorderSymbol((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountRightBorderValue")) {
      Object obj = map.get("amountRightBorderValue");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountRightBorderValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountRightBorderValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountRightBorderValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountRightBorderValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountRightBorderValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountRightBorderSymbol")) {
      Object obj = map.get("amountRightBorderSymbol");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountRightBorderSymbol((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("prepaymentType")) {
      Object obj = map.get("prepaymentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrepaymentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bondType")) {
      Object obj = map.get("bondType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBondType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("roleSerialNumber")) {
      Object obj = map.get("roleSerialNumber");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRoleSerialNumber((Long)obj);
        } else if(obj instanceof String) {
          this.setRoleSerialNumber(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRoleSerialNumber(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("roleType")) {
      Object obj = map.get("roleType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRoleType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("roleEnglishDescription")) {
      Object obj = map.get("roleEnglishDescription");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRoleEnglishDescription((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("validityPeriodLeftBorderValue")) {
      Object obj = map.get("validityPeriodLeftBorderValue");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setValidityPeriodLeftBorderValue((Long)obj);
        } else if(obj instanceof String) {
          this.setValidityPeriodLeftBorderValue(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setValidityPeriodLeftBorderValue(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("validityPeriodLeftBorderSymbol")) {
      Object obj = map.get("validityPeriodLeftBorderSymbol");
      if(obj != null) {
        if(obj instanceof String) {
          this.setValidityPeriodLeftBorderSymbol((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("validityPeriodRightBorderValue")) {
      Object obj = map.get("validityPeriodRightBorderValue");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setValidityPeriodRightBorderValue((Long)obj);
        } else if(obj instanceof String) {
          this.setValidityPeriodRightBorderValue(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setValidityPeriodRightBorderValue(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("validityPeriodRightBorderSymbol")) {
      Object obj = map.get("validityPeriodRightBorderSymbol");
      if(obj != null) {
        if(obj instanceof String) {
          this.setValidityPeriodRightBorderSymbol((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountRatioLeftBorderValue")) {
      Object obj = map.get("amountRatioLeftBorderValue");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountRatioLeftBorderValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountRatioLeftBorderValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountRatioLeftBorderValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountRatioLeftBorderValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountRatioLeftBorderValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountRatioLeftBorderSymbol")) {
      Object obj = map.get("amountRatioLeftBorderSymbol");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountRatioLeftBorderSymbol((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountRatioRightBorderValue")) {
      Object obj = map.get("amountRatioRightBorderValue");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountRatioRightBorderValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountRatioRightBorderValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountRatioRightBorderValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountRatioRightBorderValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountRatioRightBorderValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountRatioRightBorderSymbol")) {
      Object obj = map.get("amountRatioRightBorderSymbol");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountRatioRightBorderSymbol((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountLeftBorderValue")) {
      Object obj = map.get("amountLeftBorderValue");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountLeftBorderValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountLeftBorderValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountLeftBorderValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountLeftBorderValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountLeftBorderValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountLeftBorderSymbol")) {
      Object obj = map.get("amountLeftBorderSymbol");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountLeftBorderSymbol((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountRightBorderValue")) {
      Object obj = map.get("amountRightBorderValue");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountRightBorderValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountRightBorderValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountRightBorderValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountRightBorderValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountRightBorderValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountRightBorderSymbol")) {
      Object obj = map.get("amountRightBorderSymbol");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountRightBorderSymbol((String)obj);
        }
      } else {
      }
    }
  }
}
