package com.xforceplus.jctke.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-05-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AccountsPayableInterface implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 付款单号
   */
  @TableField("paymentNo")
  private String paymentNo;

  /**
   * 付款类型
   */
  @TableField("paymentType")
  private String paymentType;

  /**
   * 预付款标识
   */
  @TableField("prePaymentIdentification")
  private String prePaymentIdentification;

  /**
   * 预付款凭证号
   */
  @TableField("prePaymentVoucherNo")
  private String prePaymentVoucherNo;

  /**
   * 预付款本次核销金额
   */
  @TableField("prePaymentAmount")
  private BigDecimal prePaymentAmount;

  /**
   * 开票日期
   */
  @TableField("paperDrewDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paperDrewDate;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 发票金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 发票税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * PO列表
   */
  @TableField("poList")
  private String poList;

  /**
   * 是否需要冻结
   */
  @TableField("isFrozen")
  private String isFrozen;

  /**
   * 应付款凭证号
   */
  @TableField("paymentVoucherNo")
  private String paymentVoucherNo;

  /**
   * 逆向单凭证号
   */
  @TableField("reverseOrderVoucherNo")
  private String reverseOrderVoucherNo;

  /**
   * 预付款清账凭证
   */
  @TableField("prePayment")
  private String prePayment;

  /**
   * 应付款凭证号(607)
   */
  @TableField("paymentVoucherNoTwo")
  private String paymentVoucherNoTwo;

  /**
   * 清账凭证号(15)
   */
  @TableField("settleAccountsVoucherNo")
  private String settleAccountsVoucherNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 推送RPA任务号
   */
  @TableField("rpaTaskId")
  private String rpaTaskId;

  /**
   * 入库时间
   */
  @TableField("warehousingTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime warehousingTime;

  /**
   * 付款单id
   */
  @TableField("payMentId")
  private Long payMentId;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("paymentNo", paymentNo);
      map.put("paymentType", paymentType);
      map.put("prePaymentIdentification", prePaymentIdentification);
      map.put("prePaymentVoucherNo", prePaymentVoucherNo);
      map.put("prePaymentAmount", prePaymentAmount);
      map.put("paperDrewDate", BocpGenUtils.toTimestamp(paperDrewDate));
      map.put("invoiceNo", invoiceNo);
      map.put("amountWithTax", amountWithTax);
      map.put("taxAmount", taxAmount);
      map.put("poList", poList);
      map.put("isFrozen", isFrozen);
      map.put("paymentVoucherNo", paymentVoucherNo);
      map.put("reverseOrderVoucherNo", reverseOrderVoucherNo);
      map.put("prePayment", prePayment);
      map.put("paymentVoucherNoTwo", paymentVoucherNoTwo);
      map.put("settleAccountsVoucherNo", settleAccountsVoucherNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("rpaTaskId", rpaTaskId);
      map.put("warehousingTime", BocpGenUtils.toTimestamp(warehousingTime));
      map.put("payMentId", payMentId);
      return map;
  }

  public static AccountsPayableInterface fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    AccountsPayableInterface entity = new AccountsPayableInterface();
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prePaymentIdentification")) {
      Object obj = map.get("prePaymentIdentification");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrePaymentIdentification((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prePaymentVoucherNo")) {
      Object obj = map.get("prePaymentVoucherNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrePaymentVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prePaymentAmount")) {
      Object obj = map.get("prePaymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrePaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrePaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrePaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPrePaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrePaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaperDrewDate(null);
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("poList")) {
      Object obj = map.get("poList");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isFrozen")) {
      Object obj = map.get("isFrozen");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsFrozen((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentVoucherNo")) {
      Object obj = map.get("paymentVoucherNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverseOrderVoucherNo")) {
      Object obj = map.get("reverseOrderVoucherNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReverseOrderVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prePayment")) {
      Object obj = map.get("prePayment");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrePayment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentVoucherNoTwo")) {
      Object obj = map.get("paymentVoucherNoTwo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentVoucherNoTwo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settleAccountsVoucherNo")) {
      Object obj = map.get("settleAccountsVoucherNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettleAccountsVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rpaTaskId")) {
      Object obj = map.get("rpaTaskId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRpaTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehousingTime")) {
      Object obj = map.get("warehousingTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWarehousingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setWarehousingTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setWarehousingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setWarehousingTime(null);
      }
    }
    if(map.containsKey("payMentId")) {
      Object obj = map.get("payMentId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayMentId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPayMentId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayMentId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("prePaymentIdentification")) {
      Object obj = map.get("prePaymentIdentification");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrePaymentIdentification((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("prePaymentVoucherNo")) {
      Object obj = map.get("prePaymentVoucherNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrePaymentVoucherNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("prePaymentAmount")) {
      Object obj = map.get("prePaymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPrePaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPrePaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPrePaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setPrePaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPrePaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPaperDrewDate(null);
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("poList")) {
      Object obj = map.get("poList");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPoList((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isFrozen")) {
      Object obj = map.get("isFrozen");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsFrozen((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentVoucherNo")) {
      Object obj = map.get("paymentVoucherNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentVoucherNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reverseOrderVoucherNo")) {
      Object obj = map.get("reverseOrderVoucherNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReverseOrderVoucherNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("prePayment")) {
      Object obj = map.get("prePayment");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrePayment((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentVoucherNoTwo")) {
      Object obj = map.get("paymentVoucherNoTwo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentVoucherNoTwo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settleAccountsVoucherNo")) {
      Object obj = map.get("settleAccountsVoucherNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettleAccountsVoucherNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rpaTaskId")) {
      Object obj = map.get("rpaTaskId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRpaTaskId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warehousingTime")) {
      Object obj = map.get("warehousingTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setWarehousingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setWarehousingTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setWarehousingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setWarehousingTime(null);
      }
    }
    if(map.containsKey("payMentId")) {
      Object obj = map.get("payMentId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayMentId((Long)obj);
        } else if(obj instanceof String) {
          this.setPayMentId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayMentId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
  }
}
