package com.xforceplus.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 修改对象
 * </p>
 *
 * @author ultraman
 * @since 2023-05-30
 */
public enum EntityCode {

    PURCHASE_ORDER("purchaseOrder", "采购单"),
    INVOICE_NOTICE_BILL("invoiceNoticeBill", "开票通知单"),
    PAYMENT_MANAGE("paymentManage", "付款申请单"),
    INVOICE("invoice", "发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    EntityCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EntityCode fromCode(String code){
        switch(code) {
            case "purchaseOrder":
                return PURCHASE_ORDER;
            case "invoiceNoticeBill":
                return INVOICE_NOTICE_BILL;
            case "paymentManage":
                return PAYMENT_MANAGE;
            case "invoice":
                return INVOICE;
            default:
                return null;
        }
    }
}
