package com.xforceplus.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 待办来源
 * </p>
 *
 * @author ultraman
 * @since 2023-07-18
 */
public enum ProduceSource {

    _1("1", "采购单预处理"),
    _2("2", "收货单预处理"),
    _3("3", "采购单更新处理"),
    _4("4", "开票通知单自动创建处理"),
    _5("5", "发票更新处理"),
    _6("6", "收货单更新处理"),
    _7("7", "收货单新增处理");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProduceSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProduceSource fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
