package com.xforceplus.jctke.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 待办类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-18
 */
public enum ProduceType {

    ADD("add", "新增"),
    MODIFY("modify", "修改"),
    DEL("del", "删除");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProduceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProduceType fromCode(String code){
        switch(code) {
            case "add":
                return ADD;
            case "modify":
                return MODIFY;
            case "del":
                return DEL;
            default:
                return null;
        }
    }
}
