package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.InvoiceDetailRelation;
import com.xforceplus.jctke.service.IInvoiceDetailRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-04-13
 */
@RestController
public class InvoiceDetailRelationController {

  @Autowired
  private IInvoiceDetailRelationService invoiceDetailRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceDetailRelation ${table.comment}
   * @return
   */
  @GetMapping("/invoicedetailrelations" )
  public XfR getInvoiceDetailRelations(XfPage page, InvoiceDetailRelation invoiceDetailRelation) {
    return XfR.ok(invoiceDetailRelationServiceImpl.page(page, Wrappers.query(invoiceDetailRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicedetailrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceDetailRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceDetailRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicedetailrelations")
  public XfR save(@RequestBody InvoiceDetailRelation invoiceDetailRelation) {
     return XfR.ok(invoiceDetailRelationServiceImpl.save(invoiceDetailRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceDetailRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicedetailrelations/{id}")
  public XfR putUpdate(@RequestBody InvoiceDetailRelation invoiceDetailRelation,@PathVariable Long id) {
      invoiceDetailRelation.setId(id);
      return XfR.ok(invoiceDetailRelationServiceImpl.updateById(invoiceDetailRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceDetailRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicedetailrelations/{id}")
  public XfR patchUpdate(@RequestBody InvoiceDetailRelation invoiceDetailRelation,@PathVariable Long id) {
      InvoiceDetailRelation upinvoiceDetailRelation = invoiceDetailRelationServiceImpl.getById(id);
      if(upinvoiceDetailRelation != null){
        upinvoiceDetailRelation = ObjectCopyUtils.copyProperties(invoiceDetailRelation,upinvoiceDetailRelation,true);
      }
      return XfR.ok(invoiceDetailRelationServiceImpl.updateById(upinvoiceDetailRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicedetailrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceDetailRelationServiceImpl.removeById(id));
  }

  @PostMapping("/invoicedetailrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_detail_relation");
     params.put("request", condition);

     return XfR.ok(invoiceDetailRelationServiceImpl.querys(params));
  }

}
