package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.GoodsReceipt;
import com.xforceplus.jctke.service.IGoodsReceiptService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 收货单前端控制器
 *
 * @author ultraman
 * @date 2022-04-14
 */
@RestController
public class GoodsReceiptController {

  @Autowired
  private IGoodsReceiptService goodsReceiptServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param goodsReceipt 收货单
   * @return
   */
  @GetMapping("/goodsreceipts" )
  public XfR getGoodsReceipts(XfPage page, GoodsReceipt goodsReceipt) {
    return XfR.ok(goodsReceiptServiceImpl.page(page, Wrappers.query(goodsReceipt)));
  }

  /**
   * 通过id查询收货单
   * @param  id
   * @return XfR
   */
  @GetMapping("/goodsreceipts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(goodsReceiptServiceImpl.getById(id));
  }

  /**
   * 新增收货单
   * @param goodsReceipt 收货单
   * @return XfR
   */
  @PostMapping("/goodsreceipts")
  public XfR save(@RequestBody GoodsReceipt goodsReceipt) {
     return XfR.ok(goodsReceiptServiceImpl.save(goodsReceipt));
  }

  /**
   * 修改-传入修改后的全部数据收货单
   * @param goodsReceipt 收货单
   * @return XfR
   */
  @PutMapping("/goodsreceipts/{id}")
  public XfR putUpdate(@RequestBody GoodsReceipt goodsReceipt,@PathVariable Long id) {
      goodsReceipt.setId(id);
      return XfR.ok(goodsReceiptServiceImpl.updateById(goodsReceipt));
  }

  /**
   * 修改-传入修改的数据收货单
   * @param goodsReceipt 收货单
   * @return XfR
   */
  @PatchMapping("/goodsreceipts/{id}")
  public XfR patchUpdate(@RequestBody GoodsReceipt goodsReceipt,@PathVariable Long id) {
      GoodsReceipt upgoodsReceipt = goodsReceiptServiceImpl.getById(id);
      if(upgoodsReceipt != null){
        upgoodsReceipt = ObjectCopyUtils.copyProperties(goodsReceipt,upgoodsReceipt,true);
      }
      return XfR.ok(goodsReceiptServiceImpl.updateById(upgoodsReceipt));
  }

  /**
   * 通过id删除收货单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/goodsreceipts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(goodsReceiptServiceImpl.removeById(id));
  }

  @PostMapping("/goodsreceipts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "goods_receipt");
     params.put("request", condition);

     return XfR.ok(goodsReceiptServiceImpl.querys(params));
  }

}
