package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.PoForm;
import com.xforceplus.jctke.service.IPoFormService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-04-14
 */
@RestController
public class PoFormController {

  @Autowired
  private IPoFormService poFormServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param poForm ${table.comment}
   * @return
   */
  @GetMapping("/poforms" )
  public XfR getPoForms(XfPage page, PoForm poForm) {
    return XfR.ok(poFormServiceImpl.page(page, Wrappers.query(poForm)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/poforms/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(poFormServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param poForm ${table.comment}
   * @return XfR
   */
  @PostMapping("/poforms")
  public XfR save(@RequestBody PoForm poForm) {
     return XfR.ok(poFormServiceImpl.save(poForm));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param poForm ${table.comment}
   * @return XfR
   */
  @PutMapping("/poforms/{id}")
  public XfR putUpdate(@RequestBody PoForm poForm,@PathVariable Long id) {
      poForm.setId(id);
      return XfR.ok(poFormServiceImpl.updateById(poForm));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param poForm ${table.comment}
   * @return XfR
   */
  @PatchMapping("/poforms/{id}")
  public XfR patchUpdate(@RequestBody PoForm poForm,@PathVariable Long id) {
      PoForm uppoForm = poFormServiceImpl.getById(id);
      if(uppoForm != null){
        uppoForm = ObjectCopyUtils.copyProperties(poForm,uppoForm,true);
      }
      return XfR.ok(poFormServiceImpl.updateById(uppoForm));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/poforms/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(poFormServiceImpl.removeById(id));
  }

  @PostMapping("/poforms/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "po_form");
     params.put("request", condition);

     return XfR.ok(poFormServiceImpl.querys(params));
  }

}
