package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.AccountPayAble;
import com.xforceplus.jctke.service.IAccountPayAbleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-03-25
 */
@RestController
public class AccountPayAbleController {

  @Autowired
  private IAccountPayAbleService accountPayAbleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param accountPayAble ${table.comment}
   * @return
   */
  @GetMapping("/accountpayables" )
  public XfR getAccountPayAbles(XfPage page, AccountPayAble accountPayAble) {
    return XfR.ok(accountPayAbleServiceImpl.page(page, Wrappers.query(accountPayAble)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/accountpayables/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(accountPayAbleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param accountPayAble ${table.comment}
   * @return XfR
   */
  @PostMapping("/accountpayables")
  public XfR save(@RequestBody AccountPayAble accountPayAble) {
     return XfR.ok(accountPayAbleServiceImpl.save(accountPayAble));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param accountPayAble ${table.comment}
   * @return XfR
   */
  @PutMapping("/accountpayables/{id}")
  public XfR putUpdate(@RequestBody AccountPayAble accountPayAble,@PathVariable Long id) {
      accountPayAble.setId(id);
      return XfR.ok(accountPayAbleServiceImpl.updateById(accountPayAble));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param accountPayAble ${table.comment}
   * @return XfR
   */
  @PatchMapping("/accountpayables/{id}")
  public XfR patchUpdate(@RequestBody AccountPayAble accountPayAble,@PathVariable Long id) {
      AccountPayAble upaccountPayAble = accountPayAbleServiceImpl.getById(id);
      if(upaccountPayAble != null){
        upaccountPayAble = ObjectCopyUtils.copyProperties(accountPayAble,upaccountPayAble,true);
      }
      return XfR.ok(accountPayAbleServiceImpl.updateById(upaccountPayAble));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/accountpayables/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(accountPayAbleServiceImpl.removeById(id));
  }

  @PostMapping("/accountpayables/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "account_pay_able");
     params.put("request", condition);

     return XfR.ok(accountPayAbleServiceImpl.querys(params));
  }

}
