package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.ToubaoAmountApproval;
import com.xforceplus.jctke.service.IToubaoAmountApprovalService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-05-12
 */
@RestController
public class ToubaoAmountApprovalController {

  @Autowired
  private IToubaoAmountApprovalService toubaoAmountApprovalServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param toubaoAmountApproval ${table.comment}
   * @return
   */
  @GetMapping("/toubaoamountapprovals" )
  public XfR getToubaoAmountApprovals(XfPage page, ToubaoAmountApproval toubaoAmountApproval) {
    return XfR.ok(toubaoAmountApprovalServiceImpl.page(page, Wrappers.query(toubaoAmountApproval)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/toubaoamountapprovals/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(toubaoAmountApprovalServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param toubaoAmountApproval ${table.comment}
   * @return XfR
   */
  @PostMapping("/toubaoamountapprovals")
  public XfR save(@RequestBody ToubaoAmountApproval toubaoAmountApproval) {
     return XfR.ok(toubaoAmountApprovalServiceImpl.save(toubaoAmountApproval));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param toubaoAmountApproval ${table.comment}
   * @return XfR
   */
  @PutMapping("/toubaoamountapprovals/{id}")
  public XfR putUpdate(@RequestBody ToubaoAmountApproval toubaoAmountApproval,@PathVariable Long id) {
      toubaoAmountApproval.setId(id);
      return XfR.ok(toubaoAmountApprovalServiceImpl.updateById(toubaoAmountApproval));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param toubaoAmountApproval ${table.comment}
   * @return XfR
   */
  @PatchMapping("/toubaoamountapprovals/{id}")
  public XfR patchUpdate(@RequestBody ToubaoAmountApproval toubaoAmountApproval,@PathVariable Long id) {
      ToubaoAmountApproval uptoubaoAmountApproval = toubaoAmountApprovalServiceImpl.getById(id);
      if(uptoubaoAmountApproval != null){
        uptoubaoAmountApproval = ObjectCopyUtils.copyProperties(toubaoAmountApproval,uptoubaoAmountApproval,true);
      }
      return XfR.ok(toubaoAmountApprovalServiceImpl.updateById(uptoubaoAmountApproval));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/toubaoamountapprovals/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(toubaoAmountApprovalServiceImpl.removeById(id));
  }

  @PostMapping("/toubaoamountapprovals/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "toubao_amount_approval");
     params.put("request", condition);

     return XfR.ok(toubaoAmountApprovalServiceImpl.querys(params));
  }

}
