package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.ProfitCenterCompany;
import com.xforceplus.jctke.service.IProfitCenterCompanyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-20
 */
@RestController
public class ProfitCenterCompanyController {

  @Autowired
  private IProfitCenterCompanyService profitCenterCompanyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param profitCenterCompany ${table.comment}
   * @return
   */
  @GetMapping("/profitcentercompanys" )
  public XfR getProfitCenterCompanys(XfPage page, ProfitCenterCompany profitCenterCompany) {
    return XfR.ok(profitCenterCompanyServiceImpl.page(page, Wrappers.query(profitCenterCompany)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/profitcentercompanys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(profitCenterCompanyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param profitCenterCompany ${table.comment}
   * @return XfR
   */
  @PostMapping("/profitcentercompanys")
  public XfR save(@RequestBody ProfitCenterCompany profitCenterCompany) {
     return XfR.ok(profitCenterCompanyServiceImpl.save(profitCenterCompany));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param profitCenterCompany ${table.comment}
   * @return XfR
   */
  @PutMapping("/profitcentercompanys/{id}")
  public XfR putUpdate(@RequestBody ProfitCenterCompany profitCenterCompany,@PathVariable Long id) {
      profitCenterCompany.setId(id);
      return XfR.ok(profitCenterCompanyServiceImpl.updateById(profitCenterCompany));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param profitCenterCompany ${table.comment}
   * @return XfR
   */
  @PatchMapping("/profitcentercompanys/{id}")
  public XfR patchUpdate(@RequestBody ProfitCenterCompany profitCenterCompany,@PathVariable Long id) {
      ProfitCenterCompany upprofitCenterCompany = profitCenterCompanyServiceImpl.getById(id);
      if(upprofitCenterCompany != null){
        upprofitCenterCompany = ObjectCopyUtils.copyProperties(profitCenterCompany,upprofitCenterCompany,true);
      }
      return XfR.ok(profitCenterCompanyServiceImpl.updateById(upprofitCenterCompany));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/profitcentercompanys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(profitCenterCompanyServiceImpl.removeById(id));
  }

  @PostMapping("/profitcentercompanys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "profit_center_company");
     params.put("request", condition);

     return XfR.ok(profitCenterCompanyServiceImpl.querys(params));
  }

}
