package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.PurchaseInitFailedHistory;
import com.xforceplus.jctke.service.IPurchaseInitFailedHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-20
 */
@RestController
public class PurchaseInitFailedHistoryController {

  @Autowired
  private IPurchaseInitFailedHistoryService purchaseInitFailedHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param purchaseInitFailedHistory ${table.comment}
   * @return
   */
  @GetMapping("/purchaseinitfailedhistorys" )
  public XfR getPurchaseInitFailedHistorys(XfPage page, PurchaseInitFailedHistory purchaseInitFailedHistory) {
    return XfR.ok(purchaseInitFailedHistoryServiceImpl.page(page, Wrappers.query(purchaseInitFailedHistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/purchaseinitfailedhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(purchaseInitFailedHistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param purchaseInitFailedHistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/purchaseinitfailedhistorys")
  public XfR save(@RequestBody PurchaseInitFailedHistory purchaseInitFailedHistory) {
     return XfR.ok(purchaseInitFailedHistoryServiceImpl.save(purchaseInitFailedHistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param purchaseInitFailedHistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/purchaseinitfailedhistorys/{id}")
  public XfR putUpdate(@RequestBody PurchaseInitFailedHistory purchaseInitFailedHistory,@PathVariable Long id) {
      purchaseInitFailedHistory.setId(id);
      return XfR.ok(purchaseInitFailedHistoryServiceImpl.updateById(purchaseInitFailedHistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param purchaseInitFailedHistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/purchaseinitfailedhistorys/{id}")
  public XfR patchUpdate(@RequestBody PurchaseInitFailedHistory purchaseInitFailedHistory,@PathVariable Long id) {
      PurchaseInitFailedHistory uppurchaseInitFailedHistory = purchaseInitFailedHistoryServiceImpl.getById(id);
      if(uppurchaseInitFailedHistory != null){
        uppurchaseInitFailedHistory = ObjectCopyUtils.copyProperties(purchaseInitFailedHistory,uppurchaseInitFailedHistory,true);
      }
      return XfR.ok(purchaseInitFailedHistoryServiceImpl.updateById(uppurchaseInitFailedHistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/purchaseinitfailedhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(purchaseInitFailedHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/purchaseinitfailedhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "purchase_init_failed_history");
     params.put("request", condition);

     return XfR.ok(purchaseInitFailedHistoryServiceImpl.querys(params));
  }

}
