package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.ARPowerBiInit;
import com.xforceplus.jctke.service.IARPowerBiInitService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-21
 */
@RestController
public class ARPowerBiInitController {

  @Autowired
  private IARPowerBiInitService ARPowerBiInitServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param aRPowerBiInit ${table.comment}
   * @return
   */
  @GetMapping("/arpowerbiinits" )
  public XfR getARPowerBiInits(XfPage page, ARPowerBiInit aRPowerBiInit) {
    return XfR.ok(ARPowerBiInitServiceImpl.page(page, Wrappers.query(aRPowerBiInit)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/arpowerbiinits/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ARPowerBiInitServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param aRPowerBiInit ${table.comment}
   * @return XfR
   */
  @PostMapping("/arpowerbiinits")
  public XfR save(@RequestBody ARPowerBiInit aRPowerBiInit) {
     return XfR.ok(ARPowerBiInitServiceImpl.save(aRPowerBiInit));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param aRPowerBiInit ${table.comment}
   * @return XfR
   */
  @PutMapping("/arpowerbiinits/{id}")
  public XfR putUpdate(@RequestBody ARPowerBiInit aRPowerBiInit,@PathVariable Long id) {
      aRPowerBiInit.setId(id);
      return XfR.ok(ARPowerBiInitServiceImpl.updateById(aRPowerBiInit));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param aRPowerBiInit ${table.comment}
   * @return XfR
   */
  @PatchMapping("/arpowerbiinits/{id}")
  public XfR patchUpdate(@RequestBody ARPowerBiInit aRPowerBiInit,@PathVariable Long id) {
      ARPowerBiInit upaRPowerBiInit = ARPowerBiInitServiceImpl.getById(id);
      if(upaRPowerBiInit != null){
        upaRPowerBiInit = ObjectCopyUtils.copyProperties(aRPowerBiInit,upaRPowerBiInit,true);
      }
      return XfR.ok(ARPowerBiInitServiceImpl.updateById(upaRPowerBiInit));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/arpowerbiinits/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ARPowerBiInitServiceImpl.removeById(id));
  }

  @PostMapping("/arpowerbiinits/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "a_r_power_bi_init");
     params.put("request", condition);

     return XfR.ok(ARPowerBiInitServiceImpl.querys(params));
  }

}
