package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.PurchaseOrder;
import com.xforceplus.jctke.service.IPurchaseOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 前端控制器
 *
 * @author ultraman
 * @date 2022-07-04
 */
@RestController
public class PurchaseOrderController {

  @Autowired
  private IPurchaseOrderService purchaseOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param purchaseOrder 
   * @return
   */
  @GetMapping("/purchaseorders" )
  public XfR getPurchaseOrders(XfPage page, PurchaseOrder purchaseOrder) {
    return XfR.ok(purchaseOrderServiceImpl.page(page, Wrappers.query(purchaseOrder)));
  }

  /**
   * 通过id查询
   * @param  id
   * @return XfR
   */
  @GetMapping("/purchaseorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(purchaseOrderServiceImpl.getById(id));
  }

  /**
   * 新增
   * @param purchaseOrder 
   * @return XfR
   */
  @PostMapping("/purchaseorders")
  public XfR save(@RequestBody PurchaseOrder purchaseOrder) {
     return XfR.ok(purchaseOrderServiceImpl.save(purchaseOrder));
  }

  /**
   * 修改-传入修改后的全部数据
   * @param purchaseOrder 
   * @return XfR
   */
  @PutMapping("/purchaseorders/{id}")
  public XfR putUpdate(@RequestBody PurchaseOrder purchaseOrder,@PathVariable Long id) {
      purchaseOrder.setId(id);
      return XfR.ok(purchaseOrderServiceImpl.updateById(purchaseOrder));
  }

  /**
   * 修改-传入修改的数据
   * @param purchaseOrder 
   * @return XfR
   */
  @PatchMapping("/purchaseorders/{id}")
  public XfR patchUpdate(@RequestBody PurchaseOrder purchaseOrder,@PathVariable Long id) {
      PurchaseOrder uppurchaseOrder = purchaseOrderServiceImpl.getById(id);
      if(uppurchaseOrder != null){
        uppurchaseOrder = ObjectCopyUtils.copyProperties(purchaseOrder,uppurchaseOrder,true);
      }
      return XfR.ok(purchaseOrderServiceImpl.updateById(uppurchaseOrder));
  }

  /**
   * 通过id删除
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/purchaseorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(purchaseOrderServiceImpl.removeById(id));
  }

  @PostMapping("/purchaseorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "purchase_order");
     params.put("request", condition);

     return XfR.ok(purchaseOrderServiceImpl.querys(params));
  }

}
