package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.Imprest;
import com.xforceplus.jctke.service.IImprestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 预付单前端控制器
 *
 * @author ultraman
 * @date 2022-04-11
 */
@RestController
public class ImprestController {

  @Autowired
  private IImprestService imprestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param imprest 预付单
   * @return
   */
  @GetMapping("/imprests" )
  public XfR getImprests(XfPage page, Imprest imprest) {
    return XfR.ok(imprestServiceImpl.page(page, Wrappers.query(imprest)));
  }

  /**
   * 通过id查询预付单
   * @param  id
   * @return XfR
   */
  @GetMapping("/imprests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(imprestServiceImpl.getById(id));
  }

  /**
   * 新增预付单
   * @param imprest 预付单
   * @return XfR
   */
  @PostMapping("/imprests")
  public XfR save(@RequestBody Imprest imprest) {
     return XfR.ok(imprestServiceImpl.save(imprest));
  }

  /**
   * 修改-传入修改后的全部数据预付单
   * @param imprest 预付单
   * @return XfR
   */
  @PutMapping("/imprests/{id}")
  public XfR putUpdate(@RequestBody Imprest imprest,@PathVariable Long id) {
      imprest.setId(id);
      return XfR.ok(imprestServiceImpl.updateById(imprest));
  }

  /**
   * 修改-传入修改的数据预付单
   * @param imprest 预付单
   * @return XfR
   */
  @PatchMapping("/imprests/{id}")
  public XfR patchUpdate(@RequestBody Imprest imprest,@PathVariable Long id) {
      Imprest upimprest = imprestServiceImpl.getById(id);
      if(upimprest != null){
        upimprest = ObjectCopyUtils.copyProperties(imprest,upimprest,true);
      }
      return XfR.ok(imprestServiceImpl.updateById(upimprest));
  }

  /**
   * 通过id删除预付单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/imprests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(imprestServiceImpl.removeById(id));
  }

  @PostMapping("/imprests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "imprest");
     params.put("request", condition);

     return XfR.ok(imprestServiceImpl.querys(params));
  }

}
