package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.WbsInit;
import com.xforceplus.jctke.service.IWbsInitService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * WBS原始数据前端控制器
 *
 * @author ultraman
 * @date 2022-07-30
 */
@RestController
public class WbsInitController {

  @Autowired
  private IWbsInitService wbsInitServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param wbsInit WBS原始数据
   * @return
   */
  @GetMapping("/wbsinits" )
  public XfR getWbsInits(XfPage page, WbsInit wbsInit) {
    return XfR.ok(wbsInitServiceImpl.page(page, Wrappers.query(wbsInit)));
  }

  /**
   * 通过id查询WBS原始数据
   * @param  id
   * @return XfR
   */
  @GetMapping("/wbsinits/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(wbsInitServiceImpl.getById(id));
  }

  /**
   * 新增WBS原始数据
   * @param wbsInit WBS原始数据
   * @return XfR
   */
  @PostMapping("/wbsinits")
  public XfR save(@RequestBody WbsInit wbsInit) {
     return XfR.ok(wbsInitServiceImpl.save(wbsInit));
  }

  /**
   * 修改-传入修改后的全部数据WBS原始数据
   * @param wbsInit WBS原始数据
   * @return XfR
   */
  @PutMapping("/wbsinits/{id}")
  public XfR putUpdate(@RequestBody WbsInit wbsInit,@PathVariable Long id) {
      wbsInit.setId(id);
      return XfR.ok(wbsInitServiceImpl.updateById(wbsInit));
  }

  /**
   * 修改-传入修改的数据WBS原始数据
   * @param wbsInit WBS原始数据
   * @return XfR
   */
  @PatchMapping("/wbsinits/{id}")
  public XfR patchUpdate(@RequestBody WbsInit wbsInit,@PathVariable Long id) {
      WbsInit upwbsInit = wbsInitServiceImpl.getById(id);
      if(upwbsInit != null){
        upwbsInit = ObjectCopyUtils.copyProperties(wbsInit,upwbsInit,true);
      }
      return XfR.ok(wbsInitServiceImpl.updateById(upwbsInit));
  }

  /**
   * 通过id删除WBS原始数据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/wbsinits/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(wbsInitServiceImpl.removeById(id));
  }

  @PostMapping("/wbsinits/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "wbs_init");
     params.put("request", condition);

     return XfR.ok(wbsInitServiceImpl.querys(params));
  }

}
