package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.NoPoImprest;
import com.xforceplus.jctke.service.INoPoImprestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 前端控制器
 *
 * @author ultraman
 * @date 2022-11-02
 */
@RestController
public class NoPoImprestController {

  @Autowired
  private INoPoImprestService noPoImprestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param noPoImprest 
   * @return
   */
  @GetMapping("/nopoimprests" )
  public XfR getNoPoImprests(XfPage page, NoPoImprest noPoImprest) {
    return XfR.ok(noPoImprestServiceImpl.page(page, Wrappers.query(noPoImprest)));
  }

  /**
   * 通过id查询
   * @param  id
   * @return XfR
   */
  @GetMapping("/nopoimprests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(noPoImprestServiceImpl.getById(id));
  }

  /**
   * 新增
   * @param noPoImprest 
   * @return XfR
   */
  @PostMapping("/nopoimprests")
  public XfR save(@RequestBody NoPoImprest noPoImprest) {
     return XfR.ok(noPoImprestServiceImpl.save(noPoImprest));
  }

  /**
   * 修改-传入修改后的全部数据
   * @param noPoImprest 
   * @return XfR
   */
  @PutMapping("/nopoimprests/{id}")
  public XfR putUpdate(@RequestBody NoPoImprest noPoImprest,@PathVariable Long id) {
      noPoImprest.setId(id);
      return XfR.ok(noPoImprestServiceImpl.updateById(noPoImprest));
  }

  /**
   * 修改-传入修改的数据
   * @param noPoImprest 
   * @return XfR
   */
  @PatchMapping("/nopoimprests/{id}")
  public XfR patchUpdate(@RequestBody NoPoImprest noPoImprest,@PathVariable Long id) {
      NoPoImprest upnoPoImprest = noPoImprestServiceImpl.getById(id);
      if(upnoPoImprest != null){
        upnoPoImprest = ObjectCopyUtils.copyProperties(noPoImprest,upnoPoImprest,true);
      }
      return XfR.ok(noPoImprestServiceImpl.updateById(upnoPoImprest));
  }

  /**
   * 通过id删除
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/nopoimprests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(noPoImprestServiceImpl.removeById(id));
  }

  @PostMapping("/nopoimprests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "no_po_imprest");
     params.put("request", condition);

     return XfR.ok(noPoImprestServiceImpl.querys(params));
  }

}
