package com.xforceplus.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jctke.entity.BuyerMapping;
import com.xforceplus.jctke.service.IBuyerMappingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-01
 */
@RestController
public class BuyerMappingController {

  @Autowired
  private IBuyerMappingService buyerMappingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param buyerMapping ${table.comment}
   * @return
   */
  @GetMapping("/buyermappings" )
  public XfR getBuyerMappings(XfPage page, BuyerMapping buyerMapping) {
    return XfR.ok(buyerMappingServiceImpl.page(page, Wrappers.query(buyerMapping)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/buyermappings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(buyerMappingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param buyerMapping ${table.comment}
   * @return XfR
   */
  @PostMapping("/buyermappings")
  public XfR save(@RequestBody BuyerMapping buyerMapping) {
     return XfR.ok(buyerMappingServiceImpl.save(buyerMapping));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param buyerMapping ${table.comment}
   * @return XfR
   */
  @PutMapping("/buyermappings/{id}")
  public XfR putUpdate(@RequestBody BuyerMapping buyerMapping,@PathVariable Long id) {
      buyerMapping.setId(id);
      return XfR.ok(buyerMappingServiceImpl.updateById(buyerMapping));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param buyerMapping ${table.comment}
   * @return XfR
   */
  @PatchMapping("/buyermappings/{id}")
  public XfR patchUpdate(@RequestBody BuyerMapping buyerMapping,@PathVariable Long id) {
      BuyerMapping upbuyerMapping = buyerMappingServiceImpl.getById(id);
      if(upbuyerMapping != null){
        upbuyerMapping = ObjectCopyUtils.copyProperties(buyerMapping,upbuyerMapping,true);
      }
      return XfR.ok(buyerMappingServiceImpl.updateById(upbuyerMapping));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/buyermappings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(buyerMappingServiceImpl.removeById(id));
  }

  @PostMapping("/buyermappings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "buyer_mapping");
     params.put("request", condition);

     return XfR.ok(buyerMappingServiceImpl.querys(params));
  }

}
